/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.store;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.ImmutableRefLogDetails;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;

public class PersistVersionStore<CONTENT, METADATA, CONTENT_TYPE extends Enum<CONTENT_TYPE>>
implements VersionStore<CONTENT, METADATA, CONTENT_TYPE> {
    private final DatabaseAdapter databaseAdapter;
    protected final StoreWorker<CONTENT, METADATA, CONTENT_TYPE> storeWorker;

    public PersistVersionStore(DatabaseAdapter databaseAdapter, StoreWorker<CONTENT, METADATA, CONTENT_TYPE> storeWorker) {
        this.databaseAdapter = databaseAdapter;
        this.storeWorker = storeWorker;
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.databaseAdapter.hashOnReference(namedReference, hashOnReference);
    }

    @Nonnull
    public Hash noAncestorHash() {
        return this.databaseAdapter.noAncestorHash();
    }

    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> expectedHead, @Nonnull METADATA metadata, @Nonnull List<Operation<CONTENT>> operations, @Nonnull Callable<Void> validator) throws ReferenceNotFoundException, ReferenceConflictException {
        ImmutableCommitParams.Builder commitAttempt = ImmutableCommitParams.builder().toBranch(branch).expectedHead(expectedHead).commitMetaSerialized(this.serializeMetadata(metadata)).validator(validator);
        for (Operation<CONTENT> operation : operations) {
            if (operation instanceof Put) {
                Put op = (Put)operation;
                Object content = op.getValue();
                Object expected = op.getExpectedValue();
                if (this.storeWorker.getId(content) == null) {
                    Preconditions.checkArgument((expected == null ? 1 : 0) != 0, (String)"Expected content must not be set when creating new content. The put operation's content has no content ID and is considered as new. Key: '%s'", (Object)op.getKey());
                    content = this.storeWorker.applyId(content, UUID.randomUUID().toString());
                }
                ContentId contentId = ContentId.of((String)this.storeWorker.getId(content));
                commitAttempt.addPuts(KeyWithBytes.of((Key)op.getKey(), (ContentId)contentId, (byte)this.storeWorker.getPayload(content), (ByteString)this.storeWorker.toStoreOnReferenceState(content, arg_0 -> ((ImmutableCommitParams.Builder)commitAttempt).addAttachments(arg_0))));
                if (expected != null) {
                    String expectedId = this.storeWorker.getId(expected);
                    Preconditions.checkArgument((expectedId != null ? 1 : 0) != 0, (String)"Content id for expected content must not be null, key '%s'", (Object)op.getKey());
                    ContentId expectedContentId = ContentId.of((String)expectedId);
                    Preconditions.checkArgument((boolean)contentId.equals(expectedContentId), (String)"Content ids for new ('%s') and expected ('%s') content differ for key '%s'", (Object)contentId, (Object)expectedContentId, (Object)op.getKey());
                }
                Preconditions.checkState((!this.storeWorker.requiresGlobalState(content) ? 1 : 0) != 0, (Object)"Nessie no longer supports content with global state");
                continue;
            }
            if (operation instanceof Delete) {
                commitAttempt.addDeletes(operation.getKey());
                continue;
            }
            if (operation instanceof Unchanged) {
                commitAttempt.addUnchanged(operation.getKey());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown operation type '%s'", operation));
        }
        return this.databaseAdapter.commit((CommitParams)commitAttempt.build());
    }

    public MergeResult<Commit<METADATA, CONTENT>> transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, MetadataRewriter<METADATA> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            MergeResult adapterMergeResult = this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().toBranch(targetBranch)).expectedHead(referenceHash)).sequenceToTransplant(sequenceToTransplant).updateCommitMetadata(this.updateCommitMetadataFunction(updateCommitMetadata))).keepIndividualCommits(keepIndividualCommits)).mergeTypes(mergeTypes)).defaultMergeType(defaultMergeType)).isDryRun(dryRun)).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo);
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo));
        }
    }

    public MergeResult<Commit<METADATA, CONTENT>> merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<METADATA> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            MergeResult adapterMergeResult = this.databaseAdapter.merge(((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().toBranch(toBranch)).expectedHead(expectedHash)).mergeFromHash(fromHash).updateCommitMetadata(this.updateCommitMetadataFunction(updateCommitMetadata))).keepIndividualCommits(keepIndividualCommits)).mergeTypes(mergeTypes)).defaultMergeType(defaultMergeType)).isDryRun(dryRun)).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo);
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo));
        }
    }

    private MergeResult<Commit<METADATA, CONTENT>> storeMergeResult(MergeResult<CommitLogEntry> adapterMergeResult, boolean fetchAdditionalInfo) {
        ImmutableMergeResult.Builder storeResult = ImmutableMergeResult.builder().targetBranch(adapterMergeResult.getTargetBranch()).effectiveTargetHash(adapterMergeResult.getEffectiveTargetHash()).commonAncestor(adapterMergeResult.getCommonAncestor()).resultantTargetHash(adapterMergeResult.getResultantTargetHash()).expectedHash(adapterMergeResult.getExpectedHash()).wasApplied(adapterMergeResult.wasApplied()).wasSuccessful(adapterMergeResult.wasSuccessful()).details(adapterMergeResult.getDetails());
        BiConsumer<ImmutableCommit.Builder<METADATA, CONTENT>, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        Function<CommitLogEntry, Commit> mapper = logEntry -> {
            ImmutableCommit.Builder commit = Commit.builder();
            commit.hash(logEntry.getHash()).commitMeta(this.deserializeMetadata(logEntry.getMetadata()));
            enhancer.accept((ImmutableCommit.Builder<METADATA, CONTENT>)commit, (CommitLogEntry)logEntry);
            return commit.build();
        };
        if (adapterMergeResult.getSourceCommits() != null) {
            adapterMergeResult.getSourceCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addSourceCommits(arg_0));
        }
        if (adapterMergeResult.getTargetCommits() != null) {
            adapterMergeResult.getTargetCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addTargetCommits(arg_0));
        }
        return storeResult.build();
    }

    private MetadataRewriter<ByteString> updateCommitMetadataFunction(final MetadataRewriter<METADATA> updateCommitMetadata) {
        return new MetadataRewriter<ByteString>(){

            public ByteString rewriteSingle(ByteString metadata) {
                return PersistVersionStore.this.serializeMetadata(updateCommitMetadata.rewriteSingle(PersistVersionStore.this.deserializeMetadata(metadata)));
            }

            public ByteString squash(List<ByteString> metadata) {
                return PersistVersionStore.this.serializeMetadata(updateCommitMetadata.squash(metadata.stream().map(x$0 -> PersistVersionStore.this.deserializeMetadata(x$0)).collect(Collectors.toList())));
            }
        };
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.assign(ref, expectedHash, targetHash);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.databaseAdapter.create(ref, targetHash.orElseGet(() -> ((DatabaseAdapter)this.databaseAdapter).noAncestorHash()));
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.delete(ref, hash);
    }

    @Nonnull
    public ReferenceInfo<METADATA> getNamedRef(@Nonnull String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        ReferenceInfo namedRef = this.databaseAdapter.namedRef(ref, params);
        return namedRef.withUpdatedCommitMeta(this.deserializeMetadata((ByteString)namedRef.getHeadCommitMeta()));
    }

    @MustBeClosed
    public Stream<ReferenceInfo<METADATA>> getNamedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.databaseAdapter.namedRefs(params).map(namedRef -> namedRef.withUpdatedCommitMeta(this.deserializeMetadata((ByteString)namedRef.getHeadCommitMeta())));
    }

    private ByteString serializeMetadata(METADATA metadata) {
        return metadata != null ? this.storeWorker.getMetadataSerializer().toBytes(metadata) : null;
    }

    private METADATA deserializeMetadata(ByteString commitMeta) {
        return (METADATA)(commitMeta != null ? this.storeWorker.getMetadataSerializer().fromBytes(commitMeta) : null);
    }

    @MustBeClosed
    public Stream<Commit<METADATA, CONTENT>> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        BiConsumer<ImmutableCommit.Builder<METADATA, CONTENT>, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        return this.databaseAdapter.commitLog(hash).map(e -> {
            ImmutableCommit.Builder commit = Commit.builder().hash(e.getHash()).commitMeta(this.deserializeMetadata(e.getMetadata()));
            enhancer.accept((ImmutableCommit.Builder<METADATA, CONTENT>)commit, (CommitLogEntry)e);
            return commit.build();
        });
    }

    private BiConsumer<ImmutableCommit.Builder<METADATA, CONTENT>, CommitLogEntry> enhancerForCommitLog(boolean fetchAdditionalInfo) {
        if (!fetchAdditionalInfo) {
            return (commitBuilder, logEntry) -> {
                if (!logEntry.getParents().isEmpty()) {
                    commitBuilder.parentHash((Hash)logEntry.getParents().get(0));
                }
                logEntry.getAdditionalParents().forEach(arg_0 -> ((ImmutableCommit.Builder)commitBuilder).addAdditionalParents(arg_0));
            };
        }
        HashMap globalContents = new HashMap();
        Function<KeyWithBytes, ByteString> getGlobalContents = put -> globalContents.computeIfAbsent(put.getContentId(), cid -> this.databaseAdapter.globalContent(put.getContentId()).map(ContentIdAndBytes::getValue).orElse(null));
        return (commitBuilder, logEntry) -> {
            if (!logEntry.getParents().isEmpty()) {
                commitBuilder.parentHash((Hash)logEntry.getParents().get(0));
            }
            logEntry.getDeletes().forEach(delete -> commitBuilder.addOperations((Operation)Delete.of((Key)delete)));
            logEntry.getPuts().forEach(put -> commitBuilder.addOperations((Operation)Put.of((Key)put.getKey(), (Object)this.storeWorker.valueFromStore(put.getValue(), () -> (ByteString)getGlobalContents.apply((KeyWithBytes)put), arg_0 -> ((DatabaseAdapter)this.databaseAdapter).mapToAttachment(arg_0)))));
        };
    }

    @MustBeClosed
    public Stream<KeyEntry<CONTENT_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL).map(entry -> KeyEntry.of((Enum)this.storeWorker.getType(Byte.valueOf(entry.getType())), (Key)entry.getKey(), (String)entry.getContentId().getId()));
    }

    public CONTENT getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return this.getValues(ref, Collections.singletonList(key)).get(key);
    }

    public Map<Key, CONTENT> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.mapContentAndState((ContentAndState<ByteString>)((ContentAndState)e.getValue()))));
    }

    private CONTENT mapContentAndState(ContentAndState<ByteString> cs) {
        return (CONTENT)this.storeWorker.valueFromStore((ByteString)cs.getRefState(), () -> cs.getGlobalState(), arg_0 -> ((DatabaseAdapter)this.databaseAdapter).mapToAttachment(arg_0));
    }

    @MustBeClosed
    public Stream<Diff<CONTENT>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        Hash fromHash = this.refToHash(from);
        Hash toHash = this.refToHash(to);
        return this.databaseAdapter.diff(fromHash, toHash, KeyFilterPredicate.ALLOW_ALL).map(d -> Diff.of((Key)d.getKey(), d.getFromValue().map(v -> this.storeWorker.valueFromStore(v, () -> d.getGlobal().orElse(null), arg_0 -> ((DatabaseAdapter)this.databaseAdapter).mapToAttachment(arg_0))), d.getToValue().map(v -> this.storeWorker.valueFromStore(v, () -> d.getGlobal().orElse(null), arg_0 -> ((DatabaseAdapter)this.databaseAdapter).mapToAttachment(arg_0)))));
    }

    private Hash refToHash(Ref ref) throws ReferenceNotFoundException {
        if (ref instanceof NamedRef) {
            return this.hashOnReference((NamedRef)ref, Optional.empty());
        }
        if (ref instanceof Hash) {
            return (Hash)ref;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", ref));
    }

    @MustBeClosed
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.databaseAdapter.refLog(refLogId).map(e -> ImmutableRefLogDetails.builder().refLogId(e.getRefLogId()).refName(e.getRefName()).refType(e.getRefType()).commitHash(e.getCommitHash()).parentRefLogId((Hash)e.getParents().get(0)).operationTime(e.getOperationTime()).operation(e.getOperation()).sourceHashes((Iterable)e.getSourceHashes()).build());
    }
}

