/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.impl.ImmutableTieredVersionStoreConfig;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;
import org.projectnessie.versioned.tiered.L1;

class TestVersionEquality {
    TestVersionEquality() {
    }

    @Test
    void internalBranchL1IdEqualsEmpty() {
        InternalBranch b = new InternalBranch("n/a");
        MockStore store = new MockStore(){

            @Override
            public <C extends BaseValue<C>> void loadSingle(ValueType<C> type, Id id, C consumer) {
                InternalL1.EMPTY.applyToConsumer((L1)consumer);
            }
        };
        InternalBranch.UpdateState us = b.getUpdateState((Store)store);
        us.ensureAvailable(null, null, (TieredVersionStoreConfig)ImmutableTieredVersionStoreConfig.builder().p2CommitAttempts(1).waitOnCollapse(true).build());
        Assertions.assertEquals((Object)InternalL1.EMPTY_ID, (Object)us.getL1().getId());
    }

    @Test
    void correctSize() {
        Assertions.assertEquals((int)0, (int)InternalL1.EMPTY.size());
        Assertions.assertEquals((int)0, (int)InternalL2.EMPTY.size());
        Assertions.assertEquals((int)0, (int)InternalL3.EMPTY.size());
    }

    private static class MockStore
    implements Store {
        private MockStore() {
        }

        public void start() {
        }

        public void close() {
        }

        public void load(LoadStep loadstep) {
        }

        public <C extends BaseValue<C>> boolean putIfAbsent(SaveOp<C> saveOp) {
            return false;
        }

        public <C extends BaseValue<C>> void put(SaveOp<C> saveOp, Optional<ConditionExpression> condition) {
        }

        public <C extends BaseValue<C>> boolean delete(ValueType<C> type, Id id, Optional<ConditionExpression> condition) {
            return false;
        }

        public void save(List<SaveOp<?>> ops) {
        }

        public <C extends BaseValue<C>> void loadSingle(ValueType<C> type, Id id, C consumer) {
        }

        public <C extends BaseValue<C>> boolean update(ValueType<C> type, Id id, UpdateExpression update, Optional<ConditionExpression> condition, Optional<BaseValue<C>> consumer) throws NotFoundException {
            return false;
        }

        public <C extends BaseValue<C>> Stream<Store.Acceptor<C>> getValues(ValueType<C> type) {
            return null;
        }
    }
}

