/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import org.immutables.value.Value;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.ImmutableRemoveCommand;
import org.projectnessie.versioned.impl.condition.ImmutableSetCommand;
import org.projectnessie.versioned.impl.condition.RemoveClause;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.impl.condition.UpdateClause;
import org.projectnessie.versioned.impl.condition.UpdateClauseVisitor;
import org.projectnessie.versioned.impl.condition.Value;
import org.projectnessie.versioned.store.Entity;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestUpdateClauseVisitor {
    private static final Visitor VISITOR = new Visitor();
    private static final String ID_STR = "id";
    private static final Entity ENTITY_STR = Entity.ofString((String)"id");
    private static final String PATH_STR = "commits";
    private static final ExpressionPath PATH = ExpressionPath.builder((String)"commits").build();

    @Test
    void testRemoveClause() {
        this.testClause((UpdateClause)RemoveClause.of((ExpressionPath)PATH), UpdateCommand.Operator.REMOVE, PATH);
    }

    @Test
    void testSetClauseEquals() {
        UpdateCommand command = this.testClause((UpdateClause)SetClause.equals((ExpressionPath)PATH, (Entity)ENTITY_STR), UpdateCommand.Operator.SET, PATH);
        Assertions.assertEquals((Object)ENTITY_STR, (Object)((UpdateCommand.SetCommand)command).getEntity());
    }

    @Test
    void testSetClauseAppendToList() {
        UpdateCommand command = this.testClause((UpdateClause)SetClause.appendToList((ExpressionPath)PATH, (Entity)ENTITY_STR), UpdateCommand.Operator.SET, PATH);
        Assertions.assertEquals((Object)ENTITY_STR, (Object)((UpdateCommand.SetCommand)command).getEntity());
    }

    UpdateCommand testClause(UpdateClause clause, UpdateCommand.Operator operator, ExpressionPath path) {
        UpdateCommand command = (UpdateCommand)clause.accept((UpdateClauseVisitor)VISITOR);
        Assertions.assertEquals((Object)((Object)operator), (Object)((Object)command.getOperator()));
        Assertions.assertEquals((Object)path, (Object)command.getPath());
        return command;
    }

    static interface UpdateCommand {
        public Operator getOperator();

        public ExpressionPath getPath();

        @Value.Immutable
        public static abstract class SetCommand
        implements UpdateCommand {
            abstract Entity getEntity();
        }

        @Value.Immutable
        public static abstract class RemoveCommand
        implements UpdateCommand {
        }

        public static enum Operator {
            REMOVE,
            SET;

        }
    }

    static class Visitor
    implements UpdateClauseVisitor<UpdateCommand> {
        Visitor() {
        }

        public UpdateCommand visit(RemoveClause clause) {
            return ImmutableRemoveCommand.builder().operator(UpdateCommand.Operator.REMOVE).path(clause.getPath()).build();
        }

        public UpdateCommand visit(SetClause clause) {
            switch (clause.getValue().getType()) {
                case VALUE: {
                    return ImmutableSetCommand.builder().operator(UpdateCommand.Operator.SET).path(clause.getPath()).entity(clause.getValue().getValue()).build();
                }
                case FUNCTION: {
                    return ImmutableSetCommand.builder().operator(UpdateCommand.Operator.SET).path(clause.getPath()).entity(this.handleFunction(clause.getValue().getFunction())).build();
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported SetClause type: %s", clause.getValue().getType().name()));
        }

        private Entity handleFunction(ExpressionFunction expressionFunction) {
            if (ExpressionFunction.FunctionName.LIST_APPEND == expressionFunction.getName()) {
                return ((Value)expressionFunction.getArguments().get(1)).getValue();
            }
            throw new UnsupportedOperationException(String.format("Unsupported Set function: %s", expressionFunction.getName()));
        }
    }
}

