/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.StoreException;
import org.projectnessie.versioned.store.StoreOperationException;
import org.projectnessie.versioned.store.TracingStore;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.test.tracing.TestTracer;
import org.projectnessie.versioned.test.tracing.TestedTraceingStoreInvocation;
import org.projectnessie.versioned.tiered.BaseValue;
import org.projectnessie.versioned.tiered.L3;

class TestTracingStore {
    TestTracingStore() {
    }

    private static Stream<Arguments> storeInvocations() {
        List<Exception> storeThrows = Arrays.asList(new IllegalArgumentException("illegal-arg"), new NullPointerException("NPE"), new RuntimeException("NPE"), new StoreOperationException("NPE"), new StoreException("general store exception"), new NotFoundException("store not-found-exception"));
        Id someId = Id.of((byte[])new byte[20]);
        LoadStep someLoadStep = (LoadStep)Mockito.mock(LoadStep.class);
        L3 someConsumer = (L3)Mockito.mock(L3.class);
        SaveOp someSaveOp = (SaveOp)Mockito.mock(SaveOp.class);
        Mockito.when((Object)someSaveOp.getId()).thenReturn((Object)someId);
        Mockito.when((Object)someSaveOp.getType()).thenReturn((Object)ValueType.L3);
        Stream<TestedTraceingStoreInvocation> storeFunctions = Stream.of(new TestedTraceingStoreInvocation("Start", storeThrows).method(Store::start), new TestedTraceingStoreInvocation("Close", storeThrows).method(Store::close), new TestedTraceingStoreInvocation("Load", storeThrows).method(s -> s.load(someLoadStep)), new TestedTraceingStoreInvocation("PutIfAbsent", storeThrows).tag("nessie.store.id", (Object)"0000000000000000000000000000000000000000").tag("nessie.store.value-type", (Object)"l3").function(s -> s.putIfAbsent(someSaveOp), () -> true), new TestedTraceingStoreInvocation("Put", storeThrows).tag("nessie.store.id", (Object)"0000000000000000000000000000000000000000").tag("nessie.store.value-type", (Object)"l3").method(s -> s.put(someSaveOp, Optional.empty())), new TestedTraceingStoreInvocation("Delete", storeThrows).tag("nessie.store.id", (Object)"0000000000000000000000000000000000000000").tag("nessie.store.value-type", (Object)"l3").function(s -> s.delete(ValueType.L3, someId, Optional.empty()), () -> true), new TestedTraceingStoreInvocation("Save", storeThrows).tag("nessie.store.num-ops", (Object)1).log(Collections.singletonMap("nessie.store.save.l3.ids", "0000000000000000000000000000000000000000")).method(s -> s.save(Collections.singletonList(someSaveOp))), new TestedTraceingStoreInvocation("LoadSingle", storeThrows).tag("nessie.store.id", (Object)"0000000000000000000000000000000000000000").tag("nessie.store.value-type", (Object)"l3").method(s -> s.loadSingle(ValueType.L3, someId, (BaseValue)someConsumer)), new TestedTraceingStoreInvocation("Update", storeThrows).tag("nessie.store.id", (Object)"0000000000000000000000000000000000000000").tag("nessie.store.value-type", (Object)"l3").tag("nessie.store.update", (Object)"UpdateExpression{clauses=[]}").tag("nessie.store.condition", (Object)"Optional.empty").function(s -> s.update(ValueType.L3, someId, UpdateExpression.initial(), Optional.empty(), Optional.empty()), () -> true));
        return TestedTraceingStoreInvocation.toArguments(storeFunctions);
    }

    @BeforeAll
    static void setupGlobalTracer() {
        TestTracer.registerGlobal();
    }

    @ParameterizedTest
    @MethodSource(value={"storeInvocations"})
    void storeInvocation(TestedTraceingStoreInvocation<Store> invocation, Exception expectedThrow) throws Throwable {
        Object result;
        boolean isServerError = expectedThrow != null && (!(expectedThrow instanceof StoreException) || expectedThrow instanceof StoreOperationException);
        String opNameTag = "nessie.store.operation";
        TestTracer tracer = new TestTracer();
        tracer.registerForCurrentTest();
        Object v0 = result = invocation.getResult() != null ? invocation.getResult().get() : null;
        Stubber stubber = expectedThrow != null ? Mockito.doThrow((Throwable[])new Throwable[]{expectedThrow}) : (result != null ? Mockito.doReturn(result) : Mockito.doNothing());
        Store mockedStore = (Store)Mockito.mock(Store.class);
        invocation.getFunction().accept((Object)((Store)stubber.when((Object)mockedStore)));
        TracingStore store = new TracingStore(mockedStore);
        ThrowingConsumer storeExec = s -> {
            Object r = invocation.getFunction().accept(s);
            if (result != null) {
                Assertions.assertNotNull((Object)r);
            } else {
                Assertions.assertNull((Object)r);
            }
            if (result instanceof Stream) {
                Stream stream = (Stream)r;
                stream.forEach(ignore -> {});
                stream.close();
            }
        };
        if (expectedThrow == null) {
            storeExec.accept((Object)store);
        } else {
            Assertions.assertEquals((Object)expectedThrow.getMessage(), (Object)((Exception)Assertions.assertThrows(expectedThrow.getClass(), () -> TestTracingStore.lambda$storeInvocation$12(storeExec, (Store)store))).getMessage());
        }
        ArrayList<ImmutableMap> expectedLogs = new ArrayList<ImmutableMap>(invocation.getLogs());
        if (isServerError) {
            expectedLogs.add(ImmutableMap.of((Object)"event", (Object)"error", (Object)"error.object", (Object)expectedThrow.toString()));
        }
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder().putAll(invocation.getTags());
        if (isServerError) {
            tagsBuilder.put((Object)"error", (Object)true);
        }
        ImmutableMap expectedTags = tagsBuilder.put((Object)opNameTag, (Object)invocation.getOpName()).build();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)TracingStore.makeSpanName((String)invocation.getOpName()), (Object)tracer.getOpName()), () -> Assertions.assertEquals((Object)expectedLogs, (Object)tracer.getActiveSpan().getLogs(), (String)"expected logs don't match"), () -> TestTracingStore.lambda$storeInvocation$15((Map)expectedTags, tracer), () -> Assertions.assertTrue((boolean)tracer.isParentSet(), (String)"Span-parent not set"), () -> Assertions.assertTrue((boolean)tracer.isClosed(), (String)"Scope not closed")});
    }

    @Test
    void spanNames() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"Store.foo", (Object)TracingStore.makeSpanName((String)"Foo")), () -> Assertions.assertEquals((Object)"Store.fooBar", (Object)TracingStore.makeSpanName((String)"FooBar")), () -> Assertions.assertEquals((Object)"Store.fBar", (Object)TracingStore.makeSpanName((String)"FBar"))});
    }

    private static /* synthetic */ void lambda$storeInvocation$15(Map expectedTags, TestTracer tracer) throws Throwable {
        Assertions.assertEquals(new HashMap(expectedTags), (Object)tracer.getActiveSpan().getTags(), (String)"expected tags don't match");
    }

    private static /* synthetic */ void lambda$storeInvocation$12(ThrowingConsumer storeExec, Store store) throws Throwable {
        storeExec.accept((Object)store);
    }
}

