/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapDifference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.EntityLoadOps;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;

class DiffFinder {
    private final List<L3Diff> l3Diffs = new ArrayList<L3Diff>();
    private final L1Diff l1Diff;

    public DiffFinder(InternalL1 first, InternalL1 second) {
        this.l1Diff = new L1Diff(first, second);
    }

    public LoadStep getLoad() {
        return this.l1Diff.getLoad(this.l3Diffs);
    }

    public InternalL1 getFrom() {
        return this.l1Diff.from;
    }

    public InternalL1 getTo() {
        return this.l1Diff.to;
    }

    public Stream<KeyDiff> getKeyDiffs() {
        return this.l3Diffs.stream().flatMap(L3Diff::getKeyDiffs);
    }

    static List<DiffFinder> getFinders(List<InternalL1> l1Ascending) {
        Preconditions.checkArgument((l1Ascending.size() > 1 ? 1 : 0) != 0);
        InternalL1 previous = null;
        ArrayList<DiffFinder> diffs = new ArrayList<DiffFinder>();
        for (InternalL1 l1 : l1Ascending) {
            if (previous != null) {
                DiffFinder finder = new DiffFinder(previous, l1);
                diffs.add(finder);
            }
            previous = l1;
        }
        return diffs;
    }

    static class KeyDiff {
        private final InternalKey key;
        private final Id from;
        private final Id to;

        static KeyDiff onlyOnLeft(Map.Entry<InternalKey, Id> left) {
            return new KeyDiff(left.getKey(), left.getValue(), Id.EMPTY);
        }

        static KeyDiff onlyOnRight(Map.Entry<InternalKey, Id> right) {
            return new KeyDiff(right.getKey(), Id.EMPTY, right.getValue());
        }

        private KeyDiff(InternalKey key, Id from, Id to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        KeyDiff(Map.Entry<InternalKey, MapDifference.ValueDifference<Id>> diff) {
            this.key = diff.getKey();
            MapDifference.ValueDifference<Id> id = diff.getValue();
            this.from = (Id)id.leftValue();
            this.to = (Id)id.rightValue();
        }

        public InternalKey getKey() {
            return this.key;
        }

        public Id getFrom() {
            return this.from;
        }

        public Id getTo() {
            return this.to;
        }
    }

    private static class L3Diff {
        private InternalL3 from;
        private InternalL3 to;

        private L3Diff() {
        }

        void from(InternalL3 from) {
            this.from = from;
        }

        void to(InternalL3 to) {
            this.to = to;
        }

        Stream<KeyDiff> getKeyDiffs() {
            return InternalL3.compare(this.from, this.to);
        }
    }

    private static class L2Diff {
        private InternalL2 from;
        private InternalL2 to;

        private L2Diff() {
        }

        void from(InternalL2 from) {
            this.from = from;
        }

        void to(InternalL2 to) {
            this.to = to;
        }

        public static Optional<LoadStep> loadStep(Collection<L2Diff> diffs, List<L3Diff> l3DiffsOutput) {
            EntityLoadOps loadOps = new EntityLoadOps();
            for (L2Diff diff : diffs) {
                InternalL2 from = diff.from;
                InternalL2 to = diff.to;
                for (int i = 0; i < 199; ++i) {
                    Id b;
                    Id a = from.getId(i);
                    if (a.equals(b = to.getId(i))) continue;
                    L3Diff d = new L3Diff();
                    l3DiffsOutput.add(d);
                    loadOps.load(EntityType.L3, a, d::from);
                    loadOps.load(EntityType.L3, b, d::to);
                }
            }
            return loadOps.buildOptional();
        }
    }

    private static class L1Diff {
        private final InternalL1 from;
        private final InternalL1 to;

        public L1Diff(InternalL1 from, InternalL1 to) {
            this.from = from;
            this.to = to;
        }

        public LoadStep getLoad(List<L3Diff> l3DiffsOutput) {
            ArrayList<L2Diff> l2Diffs = new ArrayList<L2Diff>();
            EntityLoadOps loadOps = new EntityLoadOps();
            for (int i = 0; i < 43; ++i) {
                Id b;
                Id a = this.from.getId(i);
                if (a.equals(b = this.to.getId(i))) continue;
                L2Diff d = new L2Diff();
                l2Diffs.add(d);
                loadOps.load(EntityType.L2, a, d::from);
                loadOps.load(EntityType.L2, b, d::to);
            }
            return loadOps.build(() -> L2Diff.loadStep(l2Diffs, l3DiffsOutput));
        }
    }
}

