/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadOp;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;

final class EntityLoadOps {
    private final Map<EntityType<?, ?, ?>, List<Deferred>> deferred = new HashMap();
    private final Map<LoadOpKey, EntityLoadOp<?, ?, ?>> direct = new HashMap();

    EntityLoadOps() {
    }

    <C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> void load(EntityType<C, E, B> valueType, Class<E> entityType, Id id, Consumer<E> consumer) {
        this.load(valueType, id, consumer);
    }

    <C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> void load(EntityType<C, E, B> valueType, Id id, Consumer<E> consumer) {
        EntityLoadOp loadOp = this.direct.computeIfAbsent(new LoadOpKey(valueType, id), k -> new EntityLoadOp(valueType.valueType, ((LoadOpKey)k).id));
        Consumer<E> c = consumer;
        loadOp.consumers.add(c);
    }

    <C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> void loadDeferred(EntityType<C, E, B> valueType, Class<E> entityType, Supplier<Id> id, Consumer<E> consumer) {
        this.loadDeferred(valueType, id, consumer);
    }

    <C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> void loadDeferred(EntityType<C, E, B> valueType, Supplier<Id> id, Consumer<E> consumer) {
        List consumers = this.deferred.computeIfAbsent(valueType, k -> new ArrayList());
        Consumer<HasId> c = consumer;
        consumers.add(new Deferred(id, c));
    }

    boolean isEmpty() {
        return this.direct.isEmpty() && this.deferred.isEmpty();
    }

    Optional<LoadStep> buildOptional() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.build());
    }

    LoadStep build() {
        return this.build(Optional::empty);
    }

    LoadStep build(Supplier<Optional<LoadStep>> next) {
        this.deferred.forEach((type, l) -> l.forEach(d -> this.buildDeferred((EntityType<?, ?, ?>)type, (Deferred)d)));
        return new EntityLoadStep(this.direct, next);
    }

    private void buildDeferred(EntityType<?, ?, ?> type, Deferred d) {
        Consumer c = d.consumer;
        this.load(type, (Id)d.idSupplier.get(), c);
    }

    private static class EntityLoadStep
    implements LoadStep {
        private final Supplier<Optional<LoadStep>> next;
        private final Map<LoadOpKey, EntityLoadOp<?, ?, ?>> ops;

        EntityLoadStep(Map<LoadOpKey, EntityLoadOp<?, ?, ?>> ops, Supplier<Optional<LoadStep>> next) {
            this.next = next;
            this.ops = ops;
        }

        @Override
        public Optional<LoadStep> getNext() {
            return this.next.get();
        }

        @Override
        public Stream<LoadOp<?>> getOps() {
            return this.ops.values().stream().map(LoadOp.class::cast);
        }

        @Override
        public LoadStep combine(LoadStep other) {
            EntityLoadStep o = (EntityLoadStep)other;
            o.ops.forEach((id, op) -> this.ops.compute((LoadOpKey)id, (k, old) -> old != null ? old.combine(op) : op));
            return new EntityLoadStep(this.ops, () -> {
                Optional<LoadStep> nextA = this.next.get();
                Optional<LoadStep> nextB = o.next.get();
                if (nextA.isPresent()) {
                    if (nextB.isPresent()) {
                        return Optional.of(nextA.get().combine(nextB.get()));
                    }
                    return nextA;
                }
                return nextB;
            });
        }
    }

    private static class EntityLoadOp<C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>>
    extends LoadOp<C> {
        private final List<Consumer<HasId>> consumers = new ArrayList<Consumer<HasId>>();
        private B receiver;

        EntityLoadOp(ValueType<C> type, Id id) {
            super(type, id);
        }

        @Override
        public C getReceiver() {
            this.receiver = EntityType.forType(this.getValueType()).newEntityProducer();
            return (C)this.receiver;
        }

        @Override
        public void done() {
            PersistentBase entity = (PersistentBase)((PersistentBase.EntityBuilder)this.receiver).build();
            this.consumers.forEach(c -> c.accept(entity));
        }

        EntityLoadOp<C, E, B> combine(EntityLoadOp<C, E, B> other) {
            this.consumers.addAll(other.consumers);
            return this;
        }

        @Override
        public String toString() {
            return "EntityLoadOp{" + this.getValueType() + ":" + this.getId() + ", " + this.consumers.size() + " consumers}";
        }
    }

    private static final class LoadOpKey {
        private final EntityType<?, ?, ?> type;
        private final Id id;

        LoadOpKey(EntityType<?, ?, ?> type, Id id) {
            this.type = type;
            this.id = id;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadOpKey other = (LoadOpKey)obj;
            return Objects.equals(this.id, other.id) && this.type.equals(other.type);
        }

        public String toString() {
            return "LoadOpKey{type=" + this.type + ", id=" + this.id + '}';
        }
    }

    private static final class Deferred {
        private final Supplier<Id> idSupplier;
        private final Consumer<HasId> consumer;

        Deferred(Supplier<Id> idSupplier, Consumer<HasId> consumer) {
            this.idSupplier = idSupplier;
            this.consumer = consumer;
        }
    }
}

