/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.impl.EntityLoadOps;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalCommitMetadata;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.ParentList;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.Store;

class HistoryRetriever {
    private final boolean retrieveL1;
    private final boolean retrieveCommit;
    private final boolean includeEndEmpty;
    private final Store store;
    private final InternalL1 start;
    private final Id end;
    private final Map<Id, InternalL1> unsavedL1s;

    public HistoryRetriever(Store store, InternalL1 start, Id end, boolean retrieveL1, boolean retrieveCommit, boolean includeEndEmpty) {
        this(store, start, end, retrieveL1, retrieveCommit, includeEndEmpty, Collections.emptyMap());
    }

    public HistoryRetriever(Store store, InternalL1 start, Id end, boolean retrieveL1, boolean retrieveCommit, boolean includeEndEmpty, Map<Id, InternalL1> unsavedL1s) {
        this.store = store;
        this.start = start;
        this.end = end;
        this.retrieveL1 = retrieveL1;
        this.retrieveCommit = retrieveCommit;
        this.includeEndEmpty = includeEndEmpty;
        this.unsavedL1s = unsavedL1s;
    }

    Stream<HistoryItem> getStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new HistoryIterator(), 0), false);
    }

    public static Id findCommonParent(Store store, InternalL1 head1, InternalL1 head2, int maxDepth) {
        int page;
        Iterator r1 = new HistoryRetriever(store, head1, Id.EMPTY, false, false, true).getStream().map(HistoryItem::getId).iterator();
        Iterator r2 = new HistoryRetriever(store, head2, Id.EMPTY, false, false, true).getStream().map(HistoryItem::getId).iterator();
        LinkedHashSet r1Set = new LinkedHashSet();
        LinkedHashSet r2Set = new LinkedHashSet();
        for (int remainingDepth = maxDepth; remainingDepth > 0; remainingDepth -= page) {
            page = Math.min(remainingDepth, 50);
            HistoryRetriever.addNextPage(r1, r1Set, page);
            HistoryRetriever.addNextPage(r2, r2Set, page);
            Optional<Id> id = r1Set.stream().filter(r2Set::contains).findFirst();
            if (!id.isPresent()) continue;
            return id.get();
        }
        throw new IllegalStateException(String.format("Unable to find common parent within specified history depth. The maximum number of items allowed is %d.", maxDepth));
    }

    private static <T> void addNextPage(Iterator<T> input, Collection<T> consumer, int count) {
        while (input.hasNext() && count > 0) {
            consumer.add(input.next());
            --count;
        }
    }

    private class HistoryIterator
    extends AbstractIterator<HistoryItem> {
        private Iterator<HistoryItem> currentIterator;
        private boolean isLast = false;
        private HistoryItem previous = null;

        public HistoryIterator() {
            if (HistoryRetriever.this.start.getId().equals(InternalL1.EMPTY_ID) && !HistoryRetriever.this.includeEndEmpty) {
                this.currentIterator = Collections.emptyIterator();
                this.isLast = true;
            } else {
                HistoryItem item = new HistoryItem(HistoryRetriever.this.start.getId());
                item.l1 = HistoryRetriever.this.start;
                if (HistoryRetriever.this.retrieveCommit && !HistoryRetriever.this.start.getMetadataId().isEmpty()) {
                    item.commitMetadata = EntityType.COMMIT_METADATA.loadSingle(HistoryRetriever.this.store, HistoryRetriever.this.start.getMetadataId());
                }
                this.currentIterator = Collections.singleton(item).iterator();
            }
        }

        protected HistoryItem computeNext() {
            while (!this.currentIterator.hasNext() && !this.isLast && this.previous.getL1() != null) {
                try {
                    this.calculateNextList(this.previous.getL1().getParentList());
                }
                catch (ReferenceNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.currentIterator.hasNext()) {
                this.endOfData();
                return null;
            }
            this.previous = this.currentIterator.next();
            return this.previous;
        }

        private void calculateNextList(ParentList list) throws ReferenceNotFoundException {
            int max = list.getParents().size();
            ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
            EntityLoadOps loadOps = new EntityLoadOps();
            EntityLoadOps secondOps = new EntityLoadOps();
            List<Id> ids = list.getParents();
            for (int i = 0; i < max; ++i) {
                boolean lastInList = i == max - 1;
                Id parent = ids.get(i);
                if (parent.isEmpty()) break;
                if (!HistoryRetriever.this.includeEndEmpty && parent.equals(InternalL1.EMPTY_ID)) {
                    this.isLast = true;
                    break;
                }
                HistoryItem item = new HistoryItem(parent);
                items.add(item);
                if (HistoryRetriever.this.retrieveL1 || HistoryRetriever.this.retrieveCommit || lastInList) {
                    InternalL1 unsaved = (InternalL1)HistoryRetriever.this.unsavedL1s.get(parent);
                    if (unsaved != null) {
                        item.setL1(unsaved);
                    } else {
                        loadOps.load(EntityType.L1, InternalL1.class, parent, x$0 -> item.setL1(x$0));
                    }
                }
                if (HistoryRetriever.this.retrieveCommit && !parent.equals(InternalL1.EMPTY_ID)) {
                    secondOps.loadDeferred(EntityType.COMMIT_METADATA, InternalCommitMetadata.class, () -> item.getL1MetadataId(), x$0 -> item.setMetadata(x$0));
                }
                if (!parent.equals(HistoryRetriever.this.end)) continue;
                this.isLast = true;
                break;
            }
            if (items.isEmpty()) {
                this.currentIterator = Collections.emptyIterator();
                this.isLast = true;
                return;
            }
            HistoryRetriever.this.store.load(loadOps.build(secondOps::buildOptional));
            this.currentIterator = items.iterator();
        }
    }

    static class HistoryItem {
        private final Id id;
        private InternalL1 l1;
        private InternalCommitMetadata commitMetadata;

        HistoryItem(Id id) {
            this.id = id;
        }

        InternalL1 getL1() {
            return this.l1;
        }

        private void setL1(InternalL1 l1) {
            this.l1 = l1;
        }

        private Id getL1MetadataId() {
            return this.l1.getMetadataId();
        }

        Id getId() {
            return this.id;
        }

        InternalCommitMetadata getMetadata() {
            return this.commitMetadata;
        }

        private void setMetadata(InternalCommitMetadata commitMetadata) {
            this.commitMetadata = commitMetadata;
        }

        public String toString() {
            return "HistoryItem [id=" + this.id + ", l1=" + this.l1 + ", commitMetadata=" + this.commitMetadata + "]";
        }
    }
}

