/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.PositionDelta;
import org.projectnessie.versioned.store.Id;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PositionDelta", generator="Immutables")
@Immutable
final class ImmutablePositionDelta
extends PositionDelta {
    private final int position;
    private final Id oldId;
    private final Id newId;

    private ImmutablePositionDelta(int position, Id oldId, Id newId) {
        this.position = position;
        this.oldId = oldId;
        this.newId = newId;
    }

    @Override
    int getPosition() {
        return this.position;
    }

    @Override
    Id getOldId() {
        return this.oldId;
    }

    @Override
    Id getNewId() {
        return this.newId;
    }

    public final ImmutablePositionDelta withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutablePositionDelta(value, this.oldId, this.newId);
    }

    public final ImmutablePositionDelta withOldId(Id value) {
        if (this.oldId == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "oldId");
        return new ImmutablePositionDelta(this.position, newValue, this.newId);
    }

    public final ImmutablePositionDelta withNewId(Id value) {
        if (this.newId == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "newId");
        return new ImmutablePositionDelta(this.position, this.oldId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePositionDelta && this.equalTo((ImmutablePositionDelta)another);
    }

    private boolean equalTo(ImmutablePositionDelta another) {
        return this.position == another.position && this.newId.equals(another.newId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.position;
        h += (h << 5) + this.newId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PositionDelta").omitNullValues().add("position", this.position).add("newId", (Object)this.newId).toString();
    }

    public static ImmutablePositionDelta copyOf(PositionDelta instance) {
        if (instance instanceof ImmutablePositionDelta) {
            return (ImmutablePositionDelta)instance;
        }
        return ImmutablePositionDelta.getBuilder().from(instance).build();
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Generated(from="PositionDelta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POSITION = 1L;
        private static final long INIT_BIT_OLD_ID = 2L;
        private static final long INIT_BIT_NEW_ID = 4L;
        private long initBits = 7L;
        private int position;
        @Nullable
        private Id oldId;
        @Nullable
        private Id newId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PositionDelta instance) {
            Objects.requireNonNull(instance, "instance");
            this.position(instance.getPosition());
            this.oldId(instance.getOldId());
            this.newId(instance.getNewId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oldId(Id oldId) {
            this.oldId = Objects.requireNonNull(oldId, "oldId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newId(Id newId) {
            this.newId = Objects.requireNonNull(newId, "newId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePositionDelta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePositionDelta(this.position, this.oldId, this.newId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("position");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("oldId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("newId");
            }
            return "Cannot build PositionDelta, some of required attributes are not set " + attributes;
        }
    }
}

