/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Suppliers;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.projectnessie.versioned.ImmutableKey;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;

class InternalKey
implements Comparable<InternalKey>,
HasId {
    private final Key delegate;
    private final Supplier<Id> idMemo = Suppliers.memoize(() -> Id.build(h -> InternalKey.addToHasher(this, h)));
    private final Supplier<Position> positionMemo = Suppliers.memoize(() -> new Position(this.idMemo));

    public InternalKey(Key delegate) {
        this.delegate = delegate;
    }

    public InternalKey(List<String> elements) {
        this.delegate = ImmutableKey.builder().addAllElements(elements).build();
    }

    @Override
    public int compareTo(InternalKey o) {
        return this.delegate.compareTo(o.delegate);
    }

    @Override
    public Id getId() {
        return this.idMemo.get();
    }

    public int getL1Position() {
        return this.getPosition().getL1();
    }

    public int getL2Position() {
        return this.getPosition().getL2();
    }

    public Entity toEntity() {
        return Entity.ofList(this.getElements().stream().map(s -> Entity.ofString(s)));
    }

    public int estimatedSize() {
        return 3 + this.delegate.getElements().stream().mapToInt(s -> s.length()).sum();
    }

    public static InternalKey fromEntity(Entity value) {
        return new InternalKey((Key)ImmutableKey.builder().addAllElements((Iterable)value.getList().stream().map(Entity::getString).collect(Collectors.toList())).build());
    }

    public List<String> getElements() {
        return this.delegate.getElements();
    }

    public Key toKey() {
        return this.delegate;
    }

    public int hashCode() {
        return InternalKey.addToHasher(this, Hashing.murmur3_32().newHasher()).hash().asInt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalKey)) {
            return false;
        }
        InternalKey other = (InternalKey)obj;
        List thisLower = this.delegate.getElements().stream().map(String::toLowerCase).collect(Collectors.toList());
        List otherLower = other.getElements().stream().map(String::toLowerCase).collect(Collectors.toList());
        return thisLower.equals(otherLower);
    }

    public static Hasher addToHasher(InternalKey key, Hasher hasher) {
        key.delegate.getElements().forEach(s -> hasher.putString((CharSequence)s.toLowerCase(), StandardCharsets.UTF_8));
        return hasher;
    }

    public String toString() {
        return String.format("%s [%d:%d]", this.delegate, this.getL1Position(), this.getL2Position());
    }

    public Position getPosition() {
        return this.positionMemo.get();
    }

    public static class Position {
        private final int l1;
        private final int l2;

        private Position(Supplier<Id> idMemo) {
            this(Integer.remainderUnsigned(Ints.fromByteArray((byte[])idMemo.get().getValue().substring(0, 4).toByteArray()), 43), Integer.remainderUnsigned(Ints.fromByteArray((byte[])idMemo.get().getValue().substring(4, 8).toByteArray()), 199));
        }

        public Position(int l1, int l2) {
            this.l1 = l1;
            this.l2 = l2;
        }

        public int hashCode() {
            return Objects.hash(this.l1, this.l2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Position)) {
                return false;
            }
            Position other = (Position)obj;
            return this.l1 == other.l1 && this.l2 == other.l2;
        }

        public int getL1() {
            return this.l1;
        }

        public int getL2() {
            return this.l2;
        }
    }
}

