/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.HistoryRetriever;
import org.projectnessie.versioned.impl.ImmutableIncrementalList;
import org.projectnessie.versioned.impl.InternalFragment;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.Store;

abstract class KeyList {
    public static final KeyList EMPTY = new CompleteList(Collections.emptyList(), (List<InternalMutation>)ImmutableList.of());

    KeyList() {
    }

    abstract KeyList plus(Id var1, List<InternalMutation> var2);

    abstract Optional<KeyList> createCheckpointIfNeeded(InternalL1 var1, Store var2, Map<Id, InternalL1> var3);

    abstract Type getType();

    static IncrementalList incremental(Id previousCheckpointL1, List<InternalMutation> mutations, int distanceFromCheckpointCommits) {
        return ImmutableIncrementalList.builder().previousCheckpoint(previousCheckpointL1).distanceFromCheckpointCommits(distanceFromCheckpointCommits).mutations(mutations).build();
    }

    abstract Stream<InternalKeyWithPayload> getKeys(InternalL1 var1, Store var2);

    abstract List<InternalMutation> getMutations();

    abstract List<Id> getFragments();

    boolean isEmptyIncremental() {
        return this.getType() == Type.INCREMENTAL && this.getMutations().isEmpty();
    }

    boolean isFull() {
        return this.getType() == Type.FULL;
    }

    static class KeyAccumulator {
        private static final int MAX_SIZE = 391904;
        private final Store store;
        private final Set<Id> presaved;
        private final List<InternalKeyWithPayload> currentList = new ArrayList<InternalKeyWithPayload>();
        private final List<Id> fragmentIds = new ArrayList<Id>();
        private int currentListSize;

        public KeyAccumulator(Store store, Set<Id> presaved) {
            this.store = store;
            this.presaved = presaved;
        }

        public void addKey(InternalKeyWithPayload key) {
            this.currentList.add(key);
            this.currentListSize += key.getKey().estimatedSize() + 1;
            this.rotate(false);
        }

        private void rotate(boolean always) {
            if (!this.currentList.isEmpty() && (always || this.aboveThreshold())) {
                InternalFragment fragment = new InternalFragment(this.currentList);
                this.currentList.clear();
                this.currentListSize = 0;
                if (!this.presaved.contains(fragment.getId())) {
                    this.store.save(Collections.singletonList(EntityType.KEY_FRAGMENT.createSaveOpForEntity(fragment)));
                    this.fragmentIds.add(fragment.getId());
                }
            }
        }

        private boolean aboveThreshold() {
            return this.currentListSize > 391904;
        }

        public void close() {
            this.rotate(true);
        }

        public CompleteList getCompleteList(List<InternalMutation> mutations) {
            Preconditions.checkArgument((boolean)this.currentList.isEmpty());
            return new CompleteList(this.fragmentIds, mutations);
        }
    }

    static class CompleteList
    extends KeyList {
        private final List<Id> fragmentIds;
        private final List<InternalMutation> mutations;

        public CompleteList(List<Id> fragmentIds, List<InternalMutation> mutations) {
            this.fragmentIds = (List)Preconditions.checkNotNull(fragmentIds);
            this.mutations = ImmutableList.copyOf(mutations);
        }

        @Override
        public KeyList plus(Id parent, List<InternalMutation> mutations) {
            return ImmutableIncrementalList.builder().addAllMutations(mutations).distanceFromCheckpointCommits(1).previousCheckpoint(parent).build();
        }

        @Override
        public Type getType() {
            return Type.FULL;
        }

        @Override
        public Optional<KeyList> createCheckpointIfNeeded(InternalL1 startingPoint, Store store, Map<Id, InternalL1> unsavedL1s) {
            return Optional.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompleteList that = (CompleteList)o;
            return Objects.equals(this.fragmentIds, that.fragmentIds) && Objects.equals(this.mutations, that.mutations);
        }

        public int hashCode() {
            int result = this.fragmentIds != null ? this.fragmentIds.hashCode() : 0;
            result = 31 * result + (this.mutations != null ? this.mutations.hashCode() : 0);
            return result;
        }

        @Override
        Stream<InternalKeyWithPayload> getKeys(InternalL1 startingPoint, Store store) {
            return this.fragmentIds.stream().flatMap(f -> {
                InternalFragment fragment = EntityType.KEY_FRAGMENT.loadSingle(store, (Id)f);
                return fragment.getKeys().stream();
            });
        }

        @Override
        List<InternalMutation> getMutations() {
            return this.mutations;
        }

        @Override
        List<Id> getFragments() {
            return ImmutableList.copyOf(this.fragmentIds);
        }
    }

    @Value.Immutable
    static abstract class IncrementalList
    extends KeyList {
        public static final int MAX_DELTAS = 50;

        IncrementalList() {
        }

        @Override
        public abstract List<InternalMutation> getMutations();

        public abstract Id getPreviousCheckpoint();

        public abstract int getDistanceFromCheckpointCommits();

        @Override
        public KeyList plus(Id parent, List<InternalMutation> mutations) {
            return ImmutableIncrementalList.builder().addAllMutations(mutations).distanceFromCheckpointCommits(this.getDistanceFromCheckpointCommits() + 1).previousCheckpoint(this.getPreviousCheckpoint()).build();
        }

        @Override
        public Optional<KeyList> createCheckpointIfNeeded(InternalL1 startingPoint, Store store, Map<Id, InternalL1> unsavedL1s) {
            if (this.getDistanceFromCheckpointCommits() < 50) {
                return Optional.empty();
            }
            return Optional.of(this.generateNewCheckpoint(startingPoint, store, unsavedL1s));
        }

        @Override
        Stream<InternalKeyWithPayload> getKeys(InternalL1 startingPoint, Store store) {
            IterResult keys = this.getKeysIter(startingPoint, store, Collections.emptyMap());
            if (keys.isChanged()) {
                return keys.keyList;
            }
            return keys.list.getKeys(startingPoint, store);
        }

        private CompleteList generateNewCheckpoint(InternalL1 startingPoint, Store store, Map<Id, InternalL1> unsavedL1s) {
            IterResult result = this.getKeysIter(startingPoint, store, unsavedL1s);
            if (!result.isChanged()) {
                return result.list;
            }
            KeyAccumulator accum = new KeyAccumulator(store, result.previousFragmentIds);
            result.keyList.forEach(accum::addKey);
            accum.close();
            return accum.getCompleteList(this.getMutations());
        }

        private IterResult getKeysIter(InternalL1 startingPoint, Store store, Map<Id, InternalL1> unsavedL1s) {
            HistoryRetriever retriever = new HistoryRetriever(store, startingPoint, this.getPreviousCheckpoint(), true, false, true, unsavedL1s);
            ImmutableList keyLists = (ImmutableList)retriever.getStream().map(h -> h.getL1().getKeyList()).filter(kl -> !kl.isEmptyIncremental()).collect(ImmutableList.toImmutableList());
            KeyList last = (KeyList)keyLists.get(keyLists.size() - 1);
            Preconditions.checkArgument((boolean)last.isFull());
            CompleteList complete = (CompleteList)last;
            List incrementals = Lists.reverse((List)keyLists.subList(0, keyLists.size() - 1));
            HashSet removals = new HashSet();
            HashSet adds = new HashSet();
            HashMap payloads = new HashMap();
            for (KeyList kl2 : incrementals) {
                Preconditions.checkArgument((kl2.getType() == Type.INCREMENTAL ? 1 : 0) != 0);
                IncrementalList il = (IncrementalList)kl2;
                il.getMutations().forEach(m -> {
                    InternalKey key = m.getKey();
                    if (m.getType() == InternalMutation.MutationType.ADDITION) {
                        if (removals.contains(key)) {
                            removals.remove(key);
                        } else {
                            adds.add(key);
                            payloads.put(key, ((InternalMutation.InternalAddition)m).getPayload());
                        }
                    } else if (m.getType() == InternalMutation.MutationType.REMOVAL) {
                        if (adds.contains(key)) {
                            adds.remove(key);
                        } else {
                            removals.add(key);
                        }
                    } else {
                        throw new IllegalStateException("Invalid mutation type: " + m.getType().name());
                    }
                });
            }
            if (removals.isEmpty() && adds.isEmpty()) {
                return IterResult.unchanged(complete);
            }
            return IterResult.changed((Set)complete.fragmentIds.stream().collect(ImmutableSet.toImmutableSet()), Stream.concat(complete.getKeys(startingPoint, store).filter(k -> !removals.contains(k.getKey())).map(k -> payloads.containsKey(k.getKey()) ? InternalKeyWithPayload.of((Byte)payloads.get(k.getKey()), k.getKey()) : k), adds.stream().map(x -> InternalKeyWithPayload.of((Byte)payloads.get(x), x))));
        }

        @Override
        public Type getType() {
            return Type.INCREMENTAL;
        }

        private static class IterResult {
            private final CompleteList list;
            private final Stream<InternalKeyWithPayload> keyList;
            private final Set<Id> previousFragmentIds;

            private IterResult(CompleteList list, Stream<InternalKeyWithPayload> keyList, Set<Id> previousFragmentIds) {
                this.list = list;
                this.keyList = keyList;
                this.previousFragmentIds = previousFragmentIds;
            }

            public static IterResult unchanged(CompleteList list) {
                return new IterResult(list, null, null);
            }

            public static IterResult changed(Set<Id> previousFragmentIds, Stream<InternalKeyWithPayload> keys) {
                return new IterResult(null, keys, previousFragmentIds);
            }

            public boolean isChanged() {
                return this.keyList != null;
            }
        }
    }

    static enum Type {
        INCREMENTAL,
        FULL;

    }
}

