/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.tiered.BaseValue;

abstract class PersistentBase<C extends BaseValue<C>>
implements HasId {
    private Id id;
    private final long dt;

    PersistentBase() {
        this.id = null;
        this.dt = DT.now();
    }

    PersistentBase(Id id, Long dt) {
        this.id = id;
        this.dt = dt == null ? 0L : dt;
    }

    abstract Id generateId();

    C applyToConsumer(C consumer) {
        return (C)consumer.id(this.getId()).dt(this.dt);
    }

    @Override
    public final Id getId() {
        if (this.id == null) {
            this.id = this.generateId();
        }
        return this.id;
    }

    abstract <E extends PersistentBase<C>> EntityType<C, E, ?> getEntityType();

    SaveOp<C> toSaveOp() {
        return this.getEntityType().createSaveOpForEntity(this);
    }

    void ensureConsistentId() {
        assert (this.id == null || this.id.equals(this.generateId()));
    }

    public long getDt() {
        return this.dt;
    }

    static void checkCalled(Object arg, String name) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0, (Object)String.format("Cannot call %s more than once", name));
    }

    static void checkSet(Object arg, String name) {
        Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (Object)String.format("Must call %s", name));
    }

    static abstract class EntityBuilder<E extends HasId, C extends BaseValue<C>>
    implements BaseValue<C> {
        Id id;
        Long dt;

        EntityBuilder() {
        }

        @Override
        public C id(Id id) {
            PersistentBase.checkCalled(this.id, "id");
            this.id = id;
            return (C)this;
        }

        @Override
        public C dt(long dt) {
            PersistentBase.checkCalled(this.dt, "dt");
            this.dt = dt;
            return (C)this;
        }

        abstract E build();
    }
}

