/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;

class Pointer<T extends HasId> {
    private T value;
    private boolean dirty = false;

    public Pointer() {
    }

    public Pointer(T value) {
        this.value = value;
    }

    public Id apply(Transform<T> transform) {
        this.value = (HasId)transform.apply(this.value);
        this.dirty = true;
        return this.value.getId();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void set(T value) {
        this.value = value;
    }

    T get() {
        return this.value;
    }

    public String toString() {
        return (this.dirty ? "*d=" : "*=") + this.value.toString();
    }

    public static interface Transform<T> {
        public T apply(T var1);
    }
}

