/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import org.immutables.value.Value;
import org.projectnessie.versioned.impl.ImmutablePositionDelta;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.store.Id;

@Value.Immutable
@Value.Style(builder="getBuilder")
abstract class PositionDelta {
    static final PositionDelta SINGLE_ZERO = PositionDelta.builder().newId(Id.EMPTY).oldId(Id.EMPTY).position(0).build();

    PositionDelta() {
    }

    abstract int getPosition();

    @Value.Auxiliary
    abstract Id getOldId();

    abstract Id getNewId();

    static ImmutablePositionDelta.Builder builder() {
        return ImmutablePositionDelta.getBuilder();
    }

    boolean isDirty() {
        return !this.getOldId().equals(this.getNewId());
    }

    boolean wasAdded() {
        return this.getOldId().isEmpty() && !this.getNewId().isEmpty();
    }

    boolean wasAddedOrRemoved() {
        return this.wasAdded() || this.wasRemoved();
    }

    boolean wasRemoved() {
        return !this.getOldId().isEmpty() && this.getNewId().isEmpty();
    }

    final boolean isEmpty() {
        return !this.isDirty() && this.getOldId().equals(Id.EMPTY);
    }

    static PositionDelta of(int position, Id id) {
        return ImmutablePositionDelta.getBuilder().oldId(id).newId(id).position(position).build();
    }

    final InternalBranch.UnsavedDelta toUnsavedDelta() {
        InternalBranch.UnsavedDelta delta = new InternalBranch.UnsavedDelta(this.getPosition(), this.getOldId(), this.getNewId());
        return delta;
    }
}

