/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableBranchName;
import org.projectnessie.versioned.ImmutableTagName;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.DiffFinder;
import org.projectnessie.versioned.impl.EntityLoadOps;
import org.projectnessie.versioned.impl.EntitySaveOp;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.HistoryRetriever;
import org.projectnessie.versioned.impl.InconsistentValue;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.impl.InternalCommitMetadata;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalRefId;
import org.projectnessie.versioned.impl.InternalTag;
import org.projectnessie.versioned.impl.InternalValue;
import org.projectnessie.versioned.impl.PartialTree;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.Pointer;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.store.ConditionFailedException;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredVersionStore<DATA, METADATA, DATA_TYPE extends Enum<DATA_TYPE>>
implements VersionStore<DATA, METADATA, DATA_TYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieredVersionStore.class);
    private static final int MAX_MERGE_DEPTH = 200;
    private final SerializerWithPayload<DATA, DATA_TYPE> serializer;
    private final Serializer<METADATA> metadataSerializer;
    private final Executor executor;
    private final Store store;
    private final TieredVersionStoreConfig config;
    private final Counter commitRetries;
    private final Counter commitFailures;

    public TieredVersionStore(StoreWorker<DATA, METADATA, DATA_TYPE> storeWorker, Store store, TieredVersionStoreConfig config) {
        Executor executor;
        this.serializer = storeWorker.getValueSerializer();
        this.metadataSerializer = storeWorker.getMetadataSerializer();
        this.store = store;
        if (config.waitOnCollapse()) {
            executor = MoreExecutors.directExecutor();
        } else {
            executor = Executors.newCachedThreadPool();
            executor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (Executor)executor, (String)"TieredVersionStore", (Tag[])new Tag[0]);
        }
        this.executor = executor;
        this.config = config;
        CompositeMeterRegistry registry = Metrics.globalRegistry;
        this.commitRetries = Counter.builder((String)"nessie.versionstore.commitretries").tag("application", "Nessie").register((MeterRegistry)registry);
        this.commitFailures = Counter.builder((String)"nessie.versionstore.commitfailures").tag("application", "Nessie").register((MeterRegistry)registry);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        InternalL1 l1;
        if (!targetHash.isPresent()) {
            if (ref instanceof TagName) {
                throw new IllegalArgumentException("You must provide a target hash to create a tag.");
            }
            InternalBranch branch = new InternalBranch(ref.getName());
            if (!this.store.putIfAbsent(new EntitySaveOp<org.projectnessie.versioned.tiered.Ref, InternalBranch>(ValueType.REF, branch))) {
                throw new ReferenceAlreadyExistsException("A branch or tag already exists with that name.");
            }
            return branch.getLastDefinedParent().toHash();
        }
        try {
            l1 = EntityType.L1.loadSingle(this.store, Id.of(targetHash.get()));
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException("Unable to find target hash.", (Throwable)ex);
        }
        InternalRef newRef = ref instanceof TagName ? new InternalTag(null, ref.getName(), l1.getId(), DT.now()) : new InternalBranch(ref.getName(), l1);
        if (!this.store.putIfAbsent(new EntitySaveOp<org.projectnessie.versioned.tiered.Ref, InternalBranch>(ValueType.REF, (InternalBranch)newRef))) {
            throw new ReferenceAlreadyExistsException("A branch or tag already exists with that name.");
        }
        return l1.getId().toHash();
    }

    public WithHash<Ref> toRef(String refOfUnknownType) throws ReferenceNotFoundException {
        try {
            InternalRef ref = EntityType.REF.loadSingle(this.store, Id.build(refOfUnknownType));
            if (ref.getType() == InternalRef.Type.TAG) {
                return WithHash.of((Hash)ref.getTag().getCommit().toHash(), (Object)TagName.of((String)ref.getTag().getName()));
            }
            Id id = this.ensureValidL1(ref.getBranch()).getId();
            return WithHash.of((Hash)id.toHash(), (Object)BranchName.of((String)ref.getBranch().getName()));
        }
        catch (NotFoundException ref) {
            try {
                Hash hash = Hash.of((String)refOfUnknownType);
                InternalL1 l1 = EntityType.L1.loadSingle(this.store, Id.of(hash));
                return WithHash.of((Hash)l1.getId().toHash(), (Object)l1.getId().toHash());
            }
            catch (RuntimeException runtimeException) {
                throw new ReferenceNotFoundException(String.format("Unable to find the provided ref %s.", refOfUnknownType));
            }
        }
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        InternalRef iref;
        InternalRefId id = InternalRefId.of((Ref)ref);
        try {
            iref = EntityType.REF.loadSingle(this.store, id.getId());
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException(String.format("Unable to find '%s'.", ref.getName()), (Throwable)ex);
        }
        if (iref.getType() != id.getType()) {
            String t1 = iref.getType() == InternalRef.Type.BRANCH ? "tag" : "branch";
            String t2 = iref.getType() == InternalRef.Type.BRANCH ? "branch" : "tag";
            throw new ReferenceConflictException(String.format("You attempted to delete a %s using a %s invocation.", t1, t2));
        }
        ConditionExpression c = ConditionExpression.of(id.getType().typeVerification());
        if (iref.getType() == InternalRef.Type.TAG) {
            if (hash.isPresent()) {
                c = c.and(ExpressionFunction.equals(ExpressionPath.builder("commit").build(), Id.of(hash.get()).toEntity()));
            }
            if (!this.store.delete(ValueType.REF, iref.getTag().getId(), Optional.of(c))) {
                String message = "Unable to delete tag. " + (hash.isPresent() ? "The tag does not point to the hash that was referenced." : "The tag was changed to a branch while the delete was occurring.");
                throw new ReferenceConflictException(message);
            }
        } else {
            if (hash.isPresent()) {
                c = c.and(ExpressionFunction.equals(ExpressionPath.builder("commits").position(0).name("id").build(), Id.of(hash.get()).toEntity()));
                c = c.and(ExpressionFunction.equals(ExpressionFunction.size(ExpressionPath.builder("commits").build()), Entity.ofNumber(1)));
            }
            if (!this.store.delete(ValueType.REF, iref.getBranch().getId(), Optional.of(c))) {
                String message = "Unable to delete branch. " + (hash.isPresent() ? "The branch does not point to the hash that was referenced." : "The branch was changed to a tag while the delete was occurring.");
                throw new ReferenceConflictException(message);
            }
        }
    }

    public Hash commit(BranchName branchName, Optional<Hash> expectedHash, METADATA incomingCommit, List<Operation<DATA>> ops) throws ReferenceConflictException, ReferenceNotFoundException {
        InternalRef.Builder<?> builder;
        block6: {
            InternalCommitMetadata metadata = InternalCommitMetadata.of(this.metadataSerializer.toBytes(incomingCommit));
            List<InternalKey> keys = ops.stream().map(op -> new InternalKey(op.getKey())).collect(Collectors.toList());
            int loop = 0;
            InternalRefId ref = InternalRefId.ofBranch(branchName.getName());
            while (true) {
                PartialTree<DATA, DATA_TYPE> current = PartialTree.of(this.serializer, ref, keys);
                PartialTree<DATA, DATA_TYPE> expected = expectedHash.isPresent() ? PartialTree.of(this.serializer, InternalRefId.ofHash(expectedHash.get()), keys) : current;
                try {
                    this.store.load(current.getLoadChain(this::ensureValidL1, PartialTree.LoadType.NO_VALUES).combine(expected.getLoadChain(this::ensureValidL1, PartialTree.LoadType.NO_VALUES)));
                }
                catch (NotFoundException ex) {
                    this.commitFailures.increment();
                    throw new ReferenceNotFoundException("Unable to find requested ref.", (Throwable)ex);
                }
                List<OperationHolder> holders = ops.stream().map(o -> new OperationHolder(current, expected, o)).collect(Collectors.toList());
                List<InconsistentValue> mismatches = holders.stream().map(OperationHolder::verify).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                if (!mismatches.isEmpty()) {
                    LOGGER.debug("Inconsistency during commit against '{}' w/ expected-hash={}: {}", new Object[]{branchName.getName(), expectedHash, mismatches});
                    throw new InconsistentValue.InconsistentValueException(mismatches);
                }
                holders.forEach(OperationHolder::apply);
                this.store.save(Streams.concat((Stream[])new Stream[]{current.getMostSaveOps(), Stream.of(EntityType.COMMIT_METADATA.createSaveOpForEntity(metadata))}).collect(Collectors.toList()));
                PartialTree.CommitOp commitOp = current.getCommitOp(metadata.getId(), holders.stream().filter(OperationHolder::isUnchangedOperation).map(OperationHolder::getKey).collect(Collectors.toList()), true, true);
                builder = EntityType.REF.newEntityProducer();
                boolean updated = this.store.update(ValueType.REF, ref.getId(), commitOp.getUpdateWithCommit(), Optional.of(commitOp.getTreeCondition()), Optional.of(builder));
                if (updated) break block6;
                if (loop++ >= this.config.getCommitAttempts()) break;
                this.commitRetries.increment();
            }
            this.commitFailures.increment();
            throw new ReferenceConflictException(String.format("Unable to complete commit due to conflicting events. Retried %d times before failing.", this.config.getCommitAttempts()));
        }
        InternalBranch updatedBranch = ((InternalRef)builder.build()).getBranch();
        try {
            return this.ensureValidL1(updatedBranch).getId().toHash();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Failure during post-commit({}, {}, ...)", new Object[]{branchName, expectedHash, e});
            throw e;
        }
    }

    public Stream<WithHash<METADATA>> getCommits(Ref ref) throws ReferenceNotFoundException {
        try {
            InternalRef iref;
            InternalRefId id = InternalRefId.of(ref);
            InternalL1 startingL1 = id.getType() == InternalRef.Type.HASH ? EntityType.L1.loadSingle(this.store, id.getId()) : ((iref = EntityType.REF.loadSingle(this.store, id.getId())).getType() == InternalRef.Type.TAG ? EntityType.L1.loadSingle(this.store, iref.getTag().getCommit()) : this.ensureValidL1(iref.getBranch()));
            HistoryRetriever hr = new HistoryRetriever(this.store, startingL1, Id.EMPTY, false, true, false);
            return hr.getStream().map(hi -> WithHash.of((Hash)hi.getId().toHash(), (Object)this.metadataSerializer.fromBytes(hi.getMetadata().getBytes())));
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException("Unable to find request reference.", (Throwable)ex);
        }
    }

    public Stream<WithHash<NamedRef>> getNamedRefs() {
        return this.store.getValues(ValueType.REF).map(acceptor -> {
            InternalRef.Builder<?> producer = EntityType.REF.newEntityProducer();
            acceptor.applyValue(producer);
            return producer.build();
        }).map(ir -> {
            if (ir.getType() == InternalRef.Type.TAG) {
                return WithHash.of((Hash)ir.getTag().getCommit().toHash(), (Object)ImmutableTagName.builder().name(ir.getTag().getName()).build());
            }
            InternalBranch branch = ir.getBranch();
            InternalL1 l1 = this.ensureValidL1(branch);
            return WithHash.of((Hash)l1.getId().toHash(), (Object)ImmutableBranchName.builder().name(ir.getBranch().getName()).build());
        });
    }

    private InternalL1 ensureValidL1(InternalBranch branch) {
        InternalBranch.UpdateState updateState = branch.getUpdateState(this.store);
        updateState.ensureAvailable(this.store, this.executor, this.config);
        return updateState.getL1();
    }

    public Hash toHash(NamedRef ref) throws ReferenceNotFoundException {
        try {
            InternalRef iref = EntityType.REF.loadSingle(this.store, InternalRefId.ofUnknownName(ref.getName()).getId());
            if (iref.getType() == InternalRef.Type.BRANCH) {
                return this.ensureValidL1(iref.getBranch()).getId().toHash();
            }
            return iref.getTag().getCommit().toHash();
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException(String.format("Unable to find ref %s", ref.getName()), (Throwable)ex);
        }
    }

    public void assign(NamedRef namedRef, Optional<Hash> currentTarget, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        InternalRef toSave;
        InternalL1 l1;
        String name = namedRef.getName();
        Id refId = InternalRefId.of((Ref)namedRef).getId();
        Preconditions.checkArgument((!refId.isEmpty() ? 1 : 0) != 0, (Object)"Invalid target hash.");
        Id newId = Id.of(targetHash);
        Id expectedId = currentTarget.isPresent() ? Id.of(currentTarget.get()) : null;
        try {
            l1 = EntityType.L1.loadSingle(this.store, newId);
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException("Unable to find target hash.");
        }
        boolean isTag = namedRef instanceof TagName;
        InternalRef.Type type = isTag ? InternalRef.Type.TAG : InternalRef.Type.BRANCH;
        String expectedType = isTag ? "Tag" : "Branch";
        String unexpectedType = isTag ? "Branch" : "Tag";
        ConditionExpression condition = ConditionExpression.of(ExpressionFunction.equals(ExpressionPath.builder("type").build(), type.toEntity()));
        if (isTag) {
            if (currentTarget.isPresent()) {
                condition = condition.and(ExpressionFunction.equals(ExpressionPath.builder("commit").build(), expectedId.toEntity()));
            }
            toSave = new InternalTag(refId, namedRef.getName(), newId, DT.now());
        } else {
            if (currentTarget.isPresent()) {
                condition = condition.and(ExpressionFunction.equals(ExpressionPath.builder("commits").position(0).name("id").build(), expectedId.toEntity()));
            }
            toSave = new InternalBranch(name, l1);
        }
        try {
            this.store.put(new EntitySaveOp<org.projectnessie.versioned.tiered.Ref, InternalBranch>(ValueType.REF, (InternalBranch)toSave), Optional.of(condition));
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException("The current tag", (Throwable)ex);
        }
        catch (ConditionFailedException ex) {
            if (currentTarget.isPresent()) {
                throw new ReferenceConflictException(String.format("Unable to assign ref %s. The reference has changed, doesn't exist or you are trying to overwrite a %s with a %s.", name, unexpectedType, expectedType), (Throwable)ex);
            }
            throw new ReferenceNotFoundException(String.format("Unable to assign ref %s. The reference doesn't exist or you are trying to overwrite a %s with a %s.", name, unexpectedType, expectedType), (Throwable)ex);
        }
    }

    public Stream<WithType<Key, DATA_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        InternalL1 start;
        InternalRefId refId = InternalRefId.of(ref);
        switch (refId.getType()) {
            case BRANCH: {
                InternalRef branchRef = EntityType.REF.loadSingle(this.store, refId.getId());
                start = this.ensureValidL1(branchRef.getBranch());
                break;
            }
            case TAG: {
                InternalRef tagRef = EntityType.REF.loadSingle(this.store, refId.getId());
                start = EntityType.L1.loadSingle(this.store, tagRef.getTag().getCommit());
                break;
            }
            case HASH: {
                start = EntityType.L1.loadSingle(this.store, refId.getId());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return start.getKeys(this.store).map(InternalKeyWithPayload::toKey).map(x -> WithType.of((Enum)this.serializer.getType(x.getPayload()), (Object)((Key)x.getValue())));
    }

    public DATA getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        InternalKey ikey = new InternalKey(key);
        PartialTree<DATA, DATA_TYPE> tree = PartialTree.of(this.serializer, InternalRefId.of(ref), Collections.singletonList(ikey));
        this.store.load(tree.getLoadChain(this::ensureValidL1, PartialTree.LoadType.SELECT_VALUES));
        return tree.getValueForKey(ikey).orElse(null);
    }

    public List<Optional<DATA>> getValues(Ref ref, List<Key> key) throws ReferenceNotFoundException {
        List<InternalKey> keys = key.stream().map(InternalKey::new).collect(Collectors.toList());
        PartialTree<DATA, DATA_TYPE> tree = PartialTree.of(this.serializer, InternalRefId.of(ref), keys);
        this.store.load(tree.getLoadChain(this::ensureValidL1, PartialTree.LoadType.SELECT_VALUES));
        return keys.stream().map(tree::getValueForKey).collect(Collectors.toList());
    }

    public VersionStore.Collector collectGarbage() {
        throw new IllegalStateException("Not yet implemented.");
    }

    public void transplant(BranchName targetBranch, Optional<Hash> currentBranchHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        Id endTarget = Id.of(sequenceToTransplant.get(0));
        this.internalTransplant(sequenceToTransplant.get(sequenceToTransplant.size() - 1), targetBranch, currentBranchHash, true, (from, commonParent) -> {
            Stream<InternalL1> historyStream = new HistoryRetriever(this.store, from, null, true, false, true).getStream().map(HistoryRetriever.HistoryItem::getL1);
            List l1s = Lists.reverse((List)((List)TieredVersionStore.takeUntilNext(historyStream, endTarget).collect(ImmutableList.toImmutableList())));
            List hashes = l1s.stream().map(PersistentBase::getId).map(Id::toHash).skip(1L).collect(Collectors.toList());
            if (!hashes.equals(sequenceToTransplant)) {
                throw new IllegalArgumentException("Provided are not sequential and consistent with history.");
            }
            return l1s;
        });
    }

    private static Stream<InternalL1> takeUntilNext(Stream<InternalL1> stream, final Id endTarget) {
        final Spliterator iter = stream.spliterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<InternalL1>(iter.estimateSize(), 0){
            boolean found;
            boolean delivered;
            {
                super(arg0, arg1);
                this.found = false;
                this.delivered = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super InternalL1> consumer) {
                boolean hasNext = iter.tryAdvance((? super T l1) -> {
                    this.delivered = this.found;
                    this.found = l1.getId().equals(endTarget);
                    consumer.accept((InternalL1)l1);
                });
                return !this.delivered && hasNext;
            }
        }, false);
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedBranchHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.internalTransplant(fromHash, toBranch, expectedBranchHash, false, (from, commonParent) -> Lists.reverse((List)((List)new HistoryRetriever(this.store, from, commonParent, true, false, true).getStream().map(HistoryRetriever.HistoryItem::getL1).collect(ImmutableList.toImmutableList()))));
    }

    private void internalTransplant(Hash fromHash, BranchName toBranch, Optional<Hash> expectedBranchHash, boolean cherryPick, HistoryHelper historyHelper) throws ReferenceNotFoundException, ReferenceConflictException {
        List fromKeyChanges;
        InternalL1 to;
        Id commonParent;
        InternalRefId branchId = InternalRefId.ofBranch(toBranch.getName());
        Pointer fromPtr = new Pointer();
        Pointer toPtr = new Pointer();
        Pointer branch = new Pointer();
        EntityLoadOps loadOps = new EntityLoadOps();
        loadOps.load(EntityType.L1, InternalL1.class, Id.of(fromHash), fromPtr::set);
        if (expectedBranchHash.isPresent()) {
            loadOps.load(EntityType.L1, InternalL1.class, Id.of(expectedBranchHash.get()), toPtr::set);
            loadOps.load(EntityType.REF, InternalRef.class, branchId.getId(), branch::set);
        } else {
            loadOps.load(EntityType.REF, InternalRef.class, branchId.getId(), r -> toPtr.set(this.ensureValidL1(r.getBranch())));
        }
        try {
            this.store.load(loadOps.build());
        }
        catch (NotFoundException ex) {
            throw new ReferenceNotFoundException("Unable to find expected items.");
        }
        if (expectedBranchHash.isPresent() && ((InternalRef)branch.get()).getType() != InternalRef.Type.BRANCH) {
            throw new ReferenceConflictException("The requested branch is now a tag.");
        }
        InternalL1 from = (InternalL1)fromPtr.get();
        List<InternalL1> fromL1s = historyHelper.getFromL1s(from, commonParent = HistoryRetriever.findCommonParent(this.store, from, to = (InternalL1)toPtr.get(), 200));
        if (fromL1s.size() == 1) {
            Preconditions.checkArgument((boolean)fromL1s.get(0).getId().equals(InternalL1.EMPTY_ID));
            return;
        }
        List<DiffFinder> fromDiffs = DiffFinder.getFinders(fromL1s);
        LoadStep load = fromDiffs.stream().map(DiffFinder::getLoad).collect(LoadStep.toLoadStep());
        if (!cherryPick) {
            if (to.getId().equals(commonParent)) {
                this.assign((NamedRef)toBranch, expectedBranchHash, fromHash);
                return;
            }
            List toL1s = Lists.reverse((List)((List)new HistoryRetriever(this.store, to, commonParent, true, false, true).getStream().map(HistoryRetriever.HistoryItem::getL1).collect(ImmutableList.toImmutableList())));
            if (toL1s.size() == 1) {
                Preconditions.checkArgument((boolean)((InternalL1)toL1s.get(0)).getId().equals(InternalL1.EMPTY_ID));
                this.assign((NamedRef)toBranch, expectedBranchHash, fromHash);
                return;
            }
            List<DiffFinder> toDiffs = DiffFinder.getFinders(toL1s);
            load = load.combine(toDiffs.stream().map(DiffFinder::getLoad).collect(LoadStep.toLoadStep()));
            this.store.load(load);
            fromKeyChanges = (List)fromDiffs.stream().flatMap(DiffFinder::getKeyDiffs).map(DiffFinder.KeyDiff::getKey).collect(ImmutableList.toImmutableList());
            Set toKeyChanges = toDiffs.stream().flatMap(DiffFinder::getKeyDiffs).map(DiffFinder.KeyDiff::getKey).collect(Collectors.toSet());
            List conflictKeys = (List)fromKeyChanges.stream().filter(toKeyChanges::contains).collect(ImmutableList.toImmutableList());
            if (!conflictKeys.isEmpty()) {
                throw new ReferenceConflictException(String.format("The following keys have been changed in conflict: %s.", conflictKeys.stream().map(InternalKey::toString).collect(Collectors.joining(", "))));
            }
        } else {
            this.store.load(load);
            fromKeyChanges = (List)fromDiffs.stream().flatMap(DiffFinder::getKeyDiffs).map(DiffFinder.KeyDiff::getKey).collect(ImmutableList.toImmutableList());
        }
        PartialTree headToRebaseOn = PartialTree.of(this.serializer, InternalRef.Type.BRANCH, to, fromKeyChanges);
        List<DiffManager> creators = fromDiffs.stream().map(x$0 -> new DiffManager((DiffFinder)x$0)).collect(Collectors.toList());
        this.store.load(creators.stream().map(DiffManager::getLoad).collect(LoadStep.toLoadStep()).combine(headToRebaseOn.getLoadChain(this::ensureValidL1, PartialTree.LoadType.NO_VALUES)));
        ArrayList<InternalBranch.Commit> intentions = new ArrayList<InternalBranch.Commit>();
        creators.forEach(pt -> {
            PartialTree clean = headToRebaseOn.cleanClone();
            pt.apply(headToRebaseOn);
            pt.apply(clean);
            intentions.add(clean.getCommitOp(((DiffManager)pt).metadataId, Collections.emptyList(), false, true).getCommitIntention());
        });
        this.store.save(Stream.concat(creators.stream().flatMap(c -> ((DiffManager)c).tree.getMostSaveOps()), headToRebaseOn.getMostSaveOps()).distinct().collect(Collectors.toList()));
        SetClause commitUpdate = PartialTree.CommitOp.getCommitSet(intentions);
        PartialTree.CommitOp headCommit = headToRebaseOn.getCommitOp(to.getMetadataId(), Collections.emptyList(), true, false);
        boolean updated = this.store.update(ValueType.REF, branchId.getId(), headCommit.getTreeUpdate().and(commitUpdate), Optional.of(headCommit.getTreeCondition()), Optional.empty());
        if (!updated) {
            throw new ReferenceConflictException("Unable to complete commit.");
        }
    }

    public Stream<Diff<DATA>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        PartialTree<DATA, DATA_TYPE> fromTree = PartialTree.of(this.serializer, InternalRefId.of(from), Collections.emptyList());
        PartialTree<DATA, DATA_TYPE> toTree = PartialTree.of(this.serializer, InternalRefId.of(to), Collections.emptyList());
        this.store.load(fromTree.getLoadChain(this::ensureValidL1, PartialTree.LoadType.NO_VALUES).combine(toTree.getLoadChain(this::ensureValidL1, PartialTree.LoadType.NO_VALUES)));
        DiffFinder finder = new DiffFinder(fromTree.getCurrentL1(), toTree.getCurrentL1());
        this.store.load(finder.getLoad());
        HashMap values = new HashMap();
        EntityLoadOps loadOps = new EntityLoadOps();
        finder.getKeyDiffs().flatMap(k -> Stream.of(k.getFrom(), k.getTo())).distinct().filter(id -> !id.isEmpty()).forEach(id -> loadOps.load(EntityType.VALUE, InternalValue.class, (Id)id, val -> values.put(id, val)));
        this.store.load(loadOps.build());
        return finder.getKeyDiffs().map(kd -> Diff.of((Key)kd.getKey().toKey(), Optional.ofNullable(kd.getFrom()).map(values::get).map(v -> this.serializer.fromBytes(v.getBytes())), Optional.ofNullable(kd.getTo()).map(values::get).map(v -> this.serializer.fromBytes(v.getBytes()))));
    }

    class OperationHolder {
        private final PartialTree<DATA, DATA_TYPE> current;
        private final PartialTree<DATA, DATA_TYPE> expected;
        private final Operation<DATA> operation;
        private final InternalKey key;

        public OperationHolder(PartialTree<DATA, DATA_TYPE> current, PartialTree<DATA, DATA_TYPE> expected, Operation<DATA> operation) {
            this.current = (PartialTree)Preconditions.checkNotNull(current);
            this.expected = (PartialTree)Preconditions.checkNotNull(expected);
            this.operation = (Operation)Preconditions.checkNotNull(operation);
            this.key = new InternalKey(operation.getKey());
        }

        public Optional<InconsistentValue> verify() {
            Optional<Id> expectedValueId;
            if (!this.operation.shouldMatchHash()) {
                return Optional.empty();
            }
            Optional<Id> currentValueId = this.current.getValueIdForKey(this.key);
            if (!currentValueId.equals(expectedValueId = this.expected.getValueIdForKey(this.key))) {
                return Optional.of(new InconsistentValue(this.operation.getKey(), expectedValueId, currentValueId));
            }
            return Optional.empty();
        }

        public InternalKey getKey() {
            return this.key;
        }

        public void apply() {
            if (this.operation instanceof Put) {
                this.current.setValueForKey(this.key, Optional.of(((Put)this.operation).getValue()));
            } else if (this.operation instanceof Delete) {
                this.current.setValueForKey(this.key, Optional.empty());
            } else if (!(this.operation instanceof Unchanged)) {
                throw new IllegalStateException("Unknown operation type.");
            }
        }

        public boolean isUnchangedOperation() {
            return this.operation instanceof Unchanged;
        }
    }

    private class DiffManager {
        private final PartialTree<DATA, DATA_TYPE> tree;
        private final Id metadataId;
        private final DiffFinder finder;

        DiffManager(DiffFinder finder) {
            this.finder = finder;
            this.metadataId = finder.getTo().getMetadataId();
            this.tree = PartialTree.of(TieredVersionStore.this.serializer, InternalRef.Type.BRANCH, finder.getFrom(), finder.getKeyDiffs().map(DiffFinder.KeyDiff::getKey).collect(Collectors.toList()));
        }

        public InternalBranch.Commit getCommit() {
            return this.tree.getCommitOp(this.metadataId, Collections.emptyList(), false, true).getCommitIntention();
        }

        public LoadStep getLoad() {
            return this.tree.getLoadChain(x$0 -> TieredVersionStore.this.ensureValidL1(x$0), PartialTree.LoadType.NO_VALUES);
        }

        public void apply(PartialTree<DATA, DATA_TYPE> secondTree) {
            this.finder.getKeyDiffs().forEach(kd -> {
                Optional<Id> valueToSet = Optional.ofNullable(kd.getTo()).filter(i -> !i.isEmpty());
                this.tree.setValueIdForKey(kd.getKey(), valueToSet);
                secondTree.setValueIdForKey(kd.getKey(), valueToSet);
            });
        }
    }

    private static interface HistoryHelper {
        public List<InternalL1> getFromL1s(InternalL1 var1, Id var2);
    }
}

