/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.Objects;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.BaseWrappedValue;

abstract class WrappedValueBean<C extends BaseWrappedValue<C>>
extends PersistentBase<C> {
    private static final int MAX_SIZE = 262144;
    private final ByteString value;

    protected WrappedValueBean(Id id, ByteString value, Long dt) {
        super(id, dt);
        this.value = value;
        Preconditions.checkArgument((value.size() < 262144 ? 1 : 0) != 0, (Object)"Values and commit metadata must be less than 256K once serialized.");
    }

    ByteString getBytes() {
        return this.value;
    }

    protected abstract long getSeed();

    @Override
    Id generateId() {
        return Id.build(h -> h.putLong(this.getSeed()).putBytes(this.value.asReadOnlyByteBuffer()));
    }

    public int hashCode() {
        return Objects.hash(this.value, this.getSeed());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WrappedValueBean)) {
            return false;
        }
        WrappedValueBean other = (WrappedValueBean)obj;
        return Objects.equals(this.getSeed(), other.getSeed()) && Objects.equals(this.value, other.value);
    }

    @Override
    C applyToConsumer(C consumer) {
        return ((BaseWrappedValue)super.applyToConsumer(consumer)).value(this.getBytes());
    }

    static class Builder<E extends HasId, C extends BaseWrappedValue<C>>
    extends PersistentBase.EntityBuilder<E, C>
    implements BaseWrappedValue<C> {
        private ByteString value;
        private final Creator<E> builder;

        Builder(Creator<E> builder) {
            this.builder = builder;
        }

        @Override
        public C value(ByteString value) {
            PersistentBase.checkCalled(this.value, "value");
            this.value = value;
            return (C)this;
        }

        @Override
        E build() {
            PersistentBase.checkSet(this.value, "value");
            return (E)((HasId)this.builder.create(this.id, this.value, this.dt));
        }
    }

    public static interface Creator<C> {
        public C create(Id var1, ByteString var2, Long var3);
    }
}

