/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ImmutableConditionExpression;

@Value.Immutable
public abstract class ConditionExpression
implements AliasCollector.Aliasable<ConditionExpression> {
    public abstract List<ExpressionFunction> getFunctions();

    public static ConditionExpression initial() {
        return ImmutableConditionExpression.builder().build();
    }

    public String toConditionExpressionString() {
        return this.getFunctions().stream().map(ExpressionFunction::asString).collect(Collectors.joining(" AND "));
    }

    @Override
    public ConditionExpression alias(AliasCollector c) {
        return ImmutableConditionExpression.builder().functions((Iterable)this.getFunctions().stream().map(f -> f.alias(c)).collect(ImmutableList.toImmutableList())).build();
    }

    public static ConditionExpression of(ExpressionFunction ... functions) {
        return ImmutableConditionExpression.builder().addFunctions(functions).build();
    }

    public ConditionExpression and(ExpressionFunction function) {
        return ImmutableConditionExpression.builder().addAllFunctions(this.getFunctions()).addFunctions(function).build();
    }

    public ConditionExpression and(ConditionExpression expr) {
        return ImmutableConditionExpression.builder().addAllFunctions(this.getFunctions()).addAllFunctions(expr.getFunctions()).build();
    }

    public static final Collector<ConditionExpression, List<ExpressionFunction>, ConditionExpression> toConditionExpression() {
        return Collector.of(Lists::newArrayList, (A o1, T l1) -> o1.addAll(l1.getFunctions()), (o1, o2) -> {
            o1.addAll(o2);
            return o1;
        }, (A o1) -> ImmutableConditionExpression.builder().addAllFunctions((Iterable<? extends ExpressionFunction>)o1).build(), new Collector.Characteristics[0]);
    }
}

