/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ImmutableExpressionPath;
import org.projectnessie.versioned.impl.condition.ImmutableNameSegment;
import org.projectnessie.versioned.impl.condition.ImmutablePositionSegment;
import org.projectnessie.versioned.impl.condition.Value;
import org.projectnessie.versioned.impl.condition.ValueVisitor;

@Value.Immutable
public abstract class ExpressionPath
implements Value {
    public abstract NameSegment getRoot();

    public String toString() {
        return "ExpressionPath [" + this.asString() + "]";
    }

    @Override
    public String asString() {
        final StringBuilder sb = new StringBuilder();
        this.getRoot().accept(new PathVisitor<Boolean, Void, RuntimeException>(){

            @Override
            public Void visitName(NameSegment segment, Boolean first) throws RuntimeException {
                if (!first.booleanValue()) {
                    sb.append(".");
                }
                sb.append(segment.getName());
                return this.childOrNull(segment);
            }

            private Void childOrNull(PathSegment segment) {
                segment.getChild().ifPresent(c -> c.accept(this, false));
                return null;
            }

            @Override
            public Void visitPosition(PositionSegment segment, Boolean first) throws RuntimeException {
                Preconditions.checkArgument((first == false ? 1 : 0) != 0);
                sb.append("[");
                sb.append(segment.getPosition());
                sb.append("]");
                return this.childOrNull(segment);
            }
        }, true);
        return sb.toString();
    }

    @Override
    public ExpressionPath alias(AliasCollector c) {
        return ImmutableExpressionPath.builder().root(this.getRoot().alias(c)).build();
    }

    @Override
    public <T> T accept(ValueVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public PathSegment.Builder toBuilder() {
        return InternalBuilder.toBuilder(this);
    }

    public static PathSegment.Builder builder(String initialPathName) {
        InternalBuilder b = new InternalBuilder();
        PathSegment.Builder seg0 = new PathSegment.Builder(0, initialPathName, null, b);
        b.segments.add(seg0);
        return seg0;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.PATH;
    }

    @Override
    public ExpressionPath getPath() {
        return this;
    }

    private static class InternalBuilder {
        private final List<PathSegment.Builder> segments = new ArrayList<PathSegment.Builder>();

        private InternalBuilder() {
        }

        private static PathSegment.Builder toBuilder(ExpressionPath path) {
            PathSegment seg = path.getRoot();
            int i = 0;
            InternalBuilder b = new InternalBuilder();
            while (seg != null) {
                b.segments.add(new PathSegment.Builder(i, seg.isName() ? seg.asName().getName() : null, seg.isPosition() ? Integer.valueOf(seg.asPosition().getPosition()) : null, b));
                seg = seg.getChild().orElse(null);
                ++i;
            }
            return b.segments.get(b.segments.size() - 1);
        }

        private ExpressionPath build(int builderOrdinal) {
            Preconditions.checkArgument((builderOrdinal == this.segments.size() - 1 ? 1 : 0) != 0, (Object)"You can only call build on the final segment of your path.");
            Preconditions.checkArgument((!this.segments.isEmpty() ? 1 : 0) != 0, (Object)"At least one segment must be defined.");
            List reversed = Lists.reverse(this.segments);
            PathSegment segment = null;
            for (PathSegment.Builder seg : reversed) {
                if (seg.name != null) {
                    segment = ImmutableNameSegment.builder().child(Optional.ofNullable(segment)).name(seg.name).build();
                    continue;
                }
                segment = ImmutablePositionSegment.builder().child(Optional.ofNullable(segment)).position(seg.position).build();
                Preconditions.checkArgument((seg.builderOrdinal != 0 ? 1 : 0) != 0);
            }
            return ImmutableExpressionPath.builder().root((NameSegment)segment).build();
        }
    }

    @Value.Immutable
    public static abstract class NameSegment
    extends PathSegment {
        public abstract String getName();

        @Override
        public NameSegment alias(AliasCollector c) {
            return ImmutableNameSegment.builder().name(c.escape(this.getName())).child(this.getChild().map(p -> (PathSegment)p.alias(c))).build();
        }

        @Override
        public <IN, OUT, EX extends Exception> OUT accept(PathVisitor<IN, OUT, EX> visitor, IN in) throws EX {
            return visitor.visitName(this, in);
        }
    }

    @Value.Immutable
    public static abstract class PositionSegment
    extends PathSegment {
        public abstract int getPosition();

        @Override
        public PathSegment alias(AliasCollector c) {
            return ImmutablePositionSegment.builder().position(this.getPosition()).child(this.getChild().map(p -> (PathSegment)p.alias(c))).build();
        }

        @Override
        public <IN, OUT, EX extends Exception> OUT accept(PathVisitor<IN, OUT, EX> visitor, IN in) throws EX {
            return visitor.visitPosition(this, in);
        }
    }

    public static abstract class PathSegment
    implements AliasCollector.Aliasable<PathSegment> {
        public abstract <IN, OUT, EX extends Exception> OUT accept(PathVisitor<IN, OUT, EX> var1, IN var2) throws EX;

        public abstract Optional<PathSegment> getChild();

        public NameSegment asName() {
            return (NameSegment)this;
        }

        public PositionSegment asPosition() {
            return (PositionSegment)this;
        }

        public boolean isName() {
            return this instanceof NameSegment;
        }

        public boolean isPosition() {
            return this instanceof PositionSegment;
        }

        public static class Builder {
            private final int builderOrdinal;
            private final String name;
            private final Integer position;
            private final InternalBuilder builder;

            private Builder(int builderOrdinal, String path, Integer position, InternalBuilder builder) {
                Preconditions.checkArgument((position == null && path != null || position != null && path == null ? 1 : 0) != 0, (Object)"Only one of position or path can be non-null.");
                this.builderOrdinal = builderOrdinal;
                this.name = path;
                this.position = position;
                this.builder = builder;
            }

            public ExpressionPath build() {
                return this.builder.build(this.builderOrdinal);
            }

            public Builder name(String name) {
                Builder subSegment = new Builder(this.builderOrdinal + 1, name, null, this.builder);
                this.builder.segments.add(subSegment);
                return subSegment;
            }

            public Builder position(int position) {
                Builder subSegment = new Builder(this.builderOrdinal + 1, null, position, this.builder);
                this.builder.segments.add(subSegment);
                return subSegment;
            }
        }
    }

    public static interface PathVisitor<IN, OUT, EX extends Exception> {
        public OUT visitName(NameSegment var1, IN var2) throws EX;

        public OUT visitPosition(PositionSegment var1, IN var2) throws EX;
    }
}

