/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.impl.condition.Value;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetClause", generator="Immutables")
@Immutable
public final class ImmutableSetClause
extends SetClause {
    private final ExpressionPath path;
    private final Value value;

    private ImmutableSetClause(ExpressionPath path, Value value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public ExpressionPath getPath() {
        return this.path;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public final ImmutableSetClause withPath(ExpressionPath value) {
        if (this.path == value) {
            return this;
        }
        ExpressionPath newValue = Objects.requireNonNull(value, "path");
        return new ImmutableSetClause(newValue, this.value);
    }

    public final ImmutableSetClause withValue(Value value) {
        if (this.value == value) {
            return this;
        }
        Value newValue = Objects.requireNonNull(value, "value");
        return new ImmutableSetClause(this.path, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetClause && this.equalTo((ImmutableSetClause)another);
    }

    private boolean equalTo(ImmutableSetClause another) {
        return this.path.equals(another.path) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetClause").omitNullValues().add("path", (Object)this.path).add("value", (Object)this.value).toString();
    }

    public static ImmutableSetClause copyOf(SetClause instance) {
        if (instance instanceof ImmutableSetClause) {
            return (ImmutableSetClause)instance;
        }
        return ImmutableSetClause.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetClause", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private ExpressionPath path;
        @Nullable
        private Value value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SetClause instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.getPath());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(ExpressionPath path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Value value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSetClause build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetClause(this.path, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build SetClause, some of required attributes are not set " + attributes;
        }
    }
}

