/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.WithPayload;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.ImmutableKeyDelta;

@Value.Immutable
public interface KeyDelta {
    public Key getKey();

    public Id getId();

    @Nullable
    public Byte getPayload();

    public static KeyDelta of(Key key, Id id, Byte payload) {
        return ImmutableKeyDelta.builder().key(key).id(id).payload(payload).build();
    }

    public static KeyDelta of(WithPayload<Key> key, Id id) {
        return ImmutableKeyDelta.builder().key((Key)key.getValue()).id(id).payload(key.getPayload()).build();
    }

    default public WithPayload<Key> toKeyWithPayload() {
        return WithPayload.of((Byte)this.getPayload(), (Object)this.getKey());
    }
}

