/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;

public interface Store
extends AutoCloseable {
    public static final String KEY_NAME = "id";
    public static final String DT_NAME = "dt";

    public void start();

    @Override
    public void close();

    public void load(LoadStep var1);

    public <C extends BaseValue<C>> boolean putIfAbsent(SaveOp<C> var1);

    public <C extends BaseValue<C>> void put(SaveOp<C> var1, Optional<ConditionExpression> var2);

    public <C extends BaseValue<C>> boolean delete(ValueType<C> var1, Id var2, Optional<ConditionExpression> var3);

    public void save(List<SaveOp<?>> var1);

    public <C extends BaseValue<C>> void loadSingle(ValueType<C> var1, Id var2, C var3);

    public <C extends BaseValue<C>> boolean update(ValueType<C> var1, Id var2, UpdateExpression var3, Optional<ConditionExpression> var4, Optional<BaseValue<C>> var5) throws NotFoundException;

    public <C extends BaseValue<C>> Stream<Acceptor<C>> getValues(ValueType<C> var1);

    public static interface Acceptor<C extends BaseValue<C>> {
        public void applyValue(C var1);
    }
}

