/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.TracingUtil;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.StoreException;
import org.projectnessie.versioned.store.StoreOperationException;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;

public class TracingStore
implements Store {
    static final String TAG_OPERATION = "nessie.store.operation";
    static final String TAG_VALUE_TYPE = "nessie.store.value-type";
    static final String TAG_ID = "nessie.store.id";
    static final String TAG_NUM_OPS = "nessie.store.num-ops";
    static final String TAG_UPDATE = "nessie.store.update";
    static final String TAG_CONDITION = "nessie.store.condition";
    private final Store store;

    public TracingStore(Store store) {
        this.store = store;
    }

    private Tracer.SpanBuilder createSpan(String name) {
        Tracer tracer = GlobalTracer.get();
        String opName = TracingStore.makeSpanName(name);
        return tracer.buildSpan(opName).withTag(TAG_OPERATION, name).asChildOf(tracer.activeSpan());
    }

    @VisibleForTesting
    static String makeSpanName(String name) {
        return "Store." + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    @Override
    public void start() {
        try (Scope scope = this.createSpan("Start").startActive(true);){
            try {
                this.store.start();
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public void close() {
        try (Scope scope = this.createSpan("Close").startActive(true);){
            try {
                this.store.close();
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public void load(LoadStep loadstep) {
        try (Scope scope = this.createSpan("Load").startActive(true);){
            try {
                this.store.load(loadstep);
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> boolean putIfAbsent(SaveOp<C> saveOp) {
        Scope scope = this.createSpan("PutIfAbsent").withTag(TAG_VALUE_TYPE, TracingStore.safeOpTypeToString(saveOp)).withTag(TAG_ID, TracingStore.safeOpIdToString(saveOp)).startActive(true);
        try {
            boolean bl = this.store.putIfAbsent(saveOp);
            return bl;
        }
        catch (RuntimeException e) {
            throw TracingStore.traceRuntimeException(scope, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> void put(SaveOp<C> saveOp, Optional<ConditionExpression> condition) {
        try (Scope scope = this.createSpan("Put").withTag(TAG_VALUE_TYPE, TracingStore.safeOpTypeToString(saveOp)).withTag(TAG_ID, TracingStore.safeOpIdToString(saveOp)).startActive(true);){
            try {
                this.store.put(saveOp, condition);
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> boolean delete(ValueType<C> type, Id id, Optional<ConditionExpression> condition) {
        Scope scope = this.createSpan("Delete").withTag(TAG_VALUE_TYPE, TracingStore.safeName(type)).withTag(TAG_ID, TracingUtil.safeToString((Object)id)).startActive(true);
        try {
            boolean bl = this.store.delete(type, id, condition);
            return bl;
        }
        catch (RuntimeException e) {
            throw TracingStore.traceRuntimeException(scope, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public void save(List<SaveOp<?>> ops) {
        try (Scope scope = this.createSpan("Save").withTag(TAG_NUM_OPS, (Number)TracingUtil.safeSize(ops)).startActive(true);){
            try {
                scope.span().log(ops.stream().collect(Collectors.groupingBy(op -> String.format("nessie.store.save.%s.ids", op.getType().name()), Collectors.mapping(op -> op.getId().toString(), Collectors.joining(", ")))));
                this.store.save(ops);
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> void loadSingle(ValueType<C> type, Id id, C consumer) {
        try (Scope scope = this.createSpan("LoadSingle").withTag(TAG_VALUE_TYPE, TracingStore.safeName(type)).withTag(TAG_ID, TracingUtil.safeToString((Object)id)).startActive(true);){
            try {
                this.store.loadSingle(type, id, consumer);
            }
            catch (RuntimeException e) {
                throw TracingStore.traceRuntimeException(scope, e);
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> boolean update(ValueType<C> type, Id id, UpdateExpression update, Optional<ConditionExpression> condition, Optional<BaseValue<C>> consumer) throws NotFoundException {
        Scope scope = this.createSpan("Update").withTag(TAG_VALUE_TYPE, TracingStore.safeName(type)).withTag(TAG_ID, TracingUtil.safeToString((Object)id)).withTag(TAG_UPDATE, TracingUtil.safeToString((Object)update)).withTag(TAG_CONDITION, TracingUtil.safeToString(condition)).startActive(true);
        try {
            boolean bl = this.store.update(type, id, update, condition, consumer);
            return bl;
        }
        catch (RuntimeException e) {
            throw TracingStore.traceRuntimeException(scope, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public <C extends BaseValue<C>> Stream<Store.Acceptor<C>> getValues(ValueType<C> type) {
        Scope scope = this.createSpan("GetValues").withTag(TAG_VALUE_TYPE, type.name()).startActive(true);
        try {
            return (Stream)this.store.getValues(type).onClose(() -> ((Scope)scope).close());
        }
        catch (RuntimeException e) {
            e = TracingStore.traceRuntimeException(scope, e);
            scope.close();
            throw e;
        }
    }

    private static <C extends BaseValue<C>> String safeName(ValueType<C> type) {
        return type != null ? type.name() : null;
    }

    private static <C extends BaseValue<C>> String safeOpIdToString(SaveOp<C> saveOp) {
        return saveOp != null ? TracingUtil.safeToString((Object)saveOp.getId()) : "<null>";
    }

    private static <C extends BaseValue<C>> String safeOpTypeToString(SaveOp<C> saveOp) {
        return saveOp != null ? TracingStore.safeName(saveOp.getType()) : "<null>";
    }

    private static RuntimeException traceRuntimeException(Scope scope, RuntimeException e) {
        if (!(e instanceof StoreException) || e instanceof StoreOperationException) {
            return TracingUtil.traceError((Scope)scope, (RuntimeException)e);
        }
        return e;
    }
}

