/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.impl.KeyList;
import org.projectnessie.versioned.store.Id;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyList.IncrementalList", generator="Immutables")
@Immutable
final class ImmutableIncrementalList
extends KeyList.IncrementalList {
    private final ImmutableList<Id> fragments;
    private final ImmutableList<InternalMutation> mutations;
    private final Id previousCheckpoint;
    private final int distanceFromCheckpointCommits;

    private ImmutableIncrementalList(ImmutableList<Id> fragments, ImmutableList<InternalMutation> mutations, Id previousCheckpoint, int distanceFromCheckpointCommits) {
        this.fragments = fragments;
        this.mutations = mutations;
        this.previousCheckpoint = previousCheckpoint;
        this.distanceFromCheckpointCommits = distanceFromCheckpointCommits;
    }

    ImmutableList<Id> getFragments() {
        return this.fragments;
    }

    public ImmutableList<InternalMutation> getMutations() {
        return this.mutations;
    }

    @Override
    public Id getPreviousCheckpoint() {
        return this.previousCheckpoint;
    }

    @Override
    public int getDistanceFromCheckpointCommits() {
        return this.distanceFromCheckpointCommits;
    }

    public final ImmutableIncrementalList withFragments(Id ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIncrementalList((ImmutableList<Id>)newValue, this.mutations, this.previousCheckpoint, this.distanceFromCheckpointCommits);
    }

    public final ImmutableIncrementalList withFragments(Iterable<? extends Id> elements) {
        if (this.fragments == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIncrementalList((ImmutableList<Id>)newValue, this.mutations, this.previousCheckpoint, this.distanceFromCheckpointCommits);
    }

    public final ImmutableIncrementalList withMutations(InternalMutation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIncrementalList(this.fragments, (ImmutableList<InternalMutation>)newValue, this.previousCheckpoint, this.distanceFromCheckpointCommits);
    }

    public final ImmutableIncrementalList withMutations(Iterable<? extends InternalMutation> elements) {
        if (this.mutations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIncrementalList(this.fragments, (ImmutableList<InternalMutation>)newValue, this.previousCheckpoint, this.distanceFromCheckpointCommits);
    }

    public final ImmutableIncrementalList withPreviousCheckpoint(Id value) {
        if (this.previousCheckpoint == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "previousCheckpoint");
        return new ImmutableIncrementalList(this.fragments, this.mutations, newValue, this.distanceFromCheckpointCommits);
    }

    public final ImmutableIncrementalList withDistanceFromCheckpointCommits(int value) {
        if (this.distanceFromCheckpointCommits == value) {
            return this;
        }
        return new ImmutableIncrementalList(this.fragments, this.mutations, this.previousCheckpoint, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncrementalList && this.equalTo((ImmutableIncrementalList)another);
    }

    private boolean equalTo(ImmutableIncrementalList another) {
        return this.fragments.equals(another.fragments) && this.mutations.equals(another.mutations) && this.previousCheckpoint.equals(another.previousCheckpoint) && this.distanceFromCheckpointCommits == another.distanceFromCheckpointCommits;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fragments.hashCode();
        h += (h << 5) + this.mutations.hashCode();
        h += (h << 5) + this.previousCheckpoint.hashCode();
        h += (h << 5) + this.distanceFromCheckpointCommits;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IncrementalList").omitNullValues().add("fragments", this.fragments).add("mutations", this.mutations).add("previousCheckpoint", (Object)this.previousCheckpoint).add("distanceFromCheckpointCommits", this.distanceFromCheckpointCommits).toString();
    }

    public static ImmutableIncrementalList copyOf(KeyList.IncrementalList instance) {
        if (instance instanceof ImmutableIncrementalList) {
            return (ImmutableIncrementalList)instance;
        }
        return ImmutableIncrementalList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyList.IncrementalList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREVIOUS_CHECKPOINT = 1L;
        private static final long INIT_BIT_DISTANCE_FROM_CHECKPOINT_COMMITS = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Id> fragments = ImmutableList.builder();
        private ImmutableList.Builder<InternalMutation> mutations = ImmutableList.builder();
        @Nullable
        private Id previousCheckpoint;
        private int distanceFromCheckpointCommits;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyList.IncrementalList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            KeyList instance;
            long bits = 0L;
            if (object instanceof KeyList.IncrementalList) {
                instance = (KeyList.IncrementalList)object;
                this.distanceFromCheckpointCommits(((KeyList.IncrementalList)instance).getDistanceFromCheckpointCommits());
                this.previousCheckpoint(((KeyList.IncrementalList)instance).getPreviousCheckpoint());
                if ((bits & 1L) == 0L) {
                    this.addAllMutations(((KeyList.IncrementalList)instance).getMutations());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyList) {
                instance = (KeyList)object;
                this.addAllFragments(instance.getFragments());
                if ((bits & 1L) == 0L) {
                    this.addAllMutations(instance.getMutations());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addFragments(Id element) {
            this.fragments.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFragments(Id ... elements) {
            this.fragments.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fragments(Iterable<? extends Id> elements) {
            this.fragments = ImmutableList.builder();
            return this.addAllFragments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFragments(Iterable<? extends Id> elements) {
            this.fragments.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMutations(InternalMutation element) {
            this.mutations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMutations(InternalMutation ... elements) {
            this.mutations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mutations(Iterable<? extends InternalMutation> elements) {
            this.mutations = ImmutableList.builder();
            return this.addAllMutations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMutations(Iterable<? extends InternalMutation> elements) {
            this.mutations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousCheckpoint(Id previousCheckpoint) {
            this.previousCheckpoint = Objects.requireNonNull(previousCheckpoint, "previousCheckpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder distanceFromCheckpointCommits(int distanceFromCheckpointCommits) {
            this.distanceFromCheckpointCommits = distanceFromCheckpointCommits;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableIncrementalList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIncrementalList(this.fragments.build(), this.mutations.build(), this.previousCheckpoint, this.distanceFromCheckpointCommits);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("previousCheckpoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("distanceFromCheckpointCommits");
            }
            return "Cannot build IncrementalList, some of required attributes are not set " + attributes;
        }
    }
}

