/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.IdMap;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.impl.KeyList;
import org.projectnessie.versioned.impl.KeyMutationList;
import org.projectnessie.versioned.impl.ParentList;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.PositionDelta;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.tiered.L1;
import org.projectnessie.versioned.tiered.Mutation;

class InternalL1
extends PersistentBase<L1> {
    private static final long HASH_SEED = 3506039963025592061L;
    static final int SIZE = 43;
    static InternalL1 EMPTY = new InternalL1(Id.EMPTY, new IdMap(43, InternalL2.EMPTY_ID), null, KeyList.EMPTY, ParentList.EMPTY, 0L);
    static Id EMPTY_ID = EMPTY.getId();
    private final IdMap tree;
    private final Id metadataId;
    private final KeyList keyList;
    private final ParentList parentList;

    private InternalL1(Id commitId, IdMap tree, Id id, KeyList keyList, ParentList parentList, Long dt) {
        super(id, dt);
        this.metadataId = commitId;
        this.parentList = parentList;
        this.keyList = keyList;
        this.tree = tree;
        if (tree.size() != 43) {
            throw new AssertionError((Object)("tree.size(" + tree.size() + ") != " + 43));
        }
        if (id != null && !id.equals(this.generateId())) {
            throw new AssertionError((Object)("wrong id=" + id + ", expected=" + this.generateId()));
        }
    }

    InternalL1 getChildWithTree(Id metadataId, IdMap tree, KeyMutationList mutations) {
        KeyList keyList = this.keyList.plus(this.getId(), mutations.getMutations());
        ParentList parents = this.parentList.cloneWithAdditional(this.getId());
        return new InternalL1(metadataId, tree, null, keyList, parents, DT.now());
    }

    InternalL1 withCheckpointAsNecessary(Store store, Map<Id, InternalL1> unsavedL1s) {
        return this.keyList.createCheckpointIfNeeded(this, store, unsavedL1s).map(keylist -> new InternalL1(this.metadataId, this.tree, null, (KeyList)keylist, this.parentList, DT.now())).orElse(this);
    }

    Id getId(int position) {
        return this.tree.getId(position);
    }

    Id getMetadataId() {
        return this.metadataId;
    }

    ParentList getParentList() {
        return this.parentList;
    }

    Id getParentId() {
        return this.parentList.getParent();
    }

    InternalL1 set(int position, Id l2Id) {
        return new InternalL1(this.metadataId, this.tree.withId(position, l2Id), null, this.keyList, this.parentList, DT.now());
    }

    @Override
    Id generateId() {
        return Id.build(h -> {
            h.putLong(3506039963025592061L).putBytes(this.metadataId.getValue().asReadOnlyByteBuffer()).putBytes(this.parentList.getParent().getValue().asReadOnlyByteBuffer());
            this.tree.forEach(id -> h.putBytes(id.getValue().asReadOnlyByteBuffer()));
        });
    }

    Stream<InternalKeyWithPayload> getKeys(Store store) {
        return this.keyList.getKeys(this, store);
    }

    IdMap getMap() {
        return this.tree;
    }

    List<PositionDelta> getChanges() {
        return this.tree.getChanges();
    }

    KeyList getKeyList() {
        return this.keyList;
    }

    int size() {
        int count = 0;
        for (Id id : this.tree) {
            if (id.equals(InternalL2.EMPTY_ID)) continue;
            ++count;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalL1 l1 = (InternalL1)o;
        return Objects.equals(this.tree, l1.tree) && Objects.equals(this.metadataId, l1.metadataId) && Objects.equals(this.keyList, l1.keyList) && Objects.equals(this.parentList, l1.parentList);
    }

    public int hashCode() {
        return Objects.hash(this.tree, this.metadataId, this.keyList, this.parentList);
    }

    @Override
    L1 applyToConsumer(L1 consumer) {
        super.applyToConsumer(consumer).commitMetadataId(this.metadataId).keyMutations(this.keyList.getMutations().stream().map(InternalMutation::toMutation)).children(this.tree.stream()).ancestors(this.parentList.getParents().stream());
        if (this.keyList.isFull()) {
            consumer.completeKeyList(this.keyList.getFragments().stream());
        } else {
            KeyList.IncrementalList list = (KeyList.IncrementalList)this.keyList;
            consumer.incrementalKeyList(list.getPreviousCheckpoint(), list.getDistanceFromCheckpointCommits());
        }
        return consumer;
    }

    @Override
    EntityType<L1, InternalL1, Builder> getEntityType() {
        return EntityType.L1;
    }

    static final class Builder
    extends PersistentBase.EntityBuilder<InternalL1, L1>
    implements L1 {
        private Id metadataId;
        private Stream<Id> ancestors;
        private Stream<Id> children;
        private final List<InternalMutation> keyChanges = new ArrayList<InternalMutation>();
        private Id checkpointId;
        private int distanceFromCheckpoint;
        private Stream<Id> fragmentIds;

        Builder() {
        }

        @Override
        public Builder commitMetadataId(Id id) {
            PersistentBase.checkCalled(this.metadataId, "commitMetadataId");
            this.metadataId = id;
            return this;
        }

        @Override
        public Builder ancestors(Stream<Id> ids) {
            PersistentBase.checkCalled(this.ancestors, "addAncestors");
            this.ancestors = ids;
            return this;
        }

        @Override
        public Builder children(Stream<Id> ids) {
            PersistentBase.checkCalled(this.children, "children");
            this.children = ids;
            return this;
        }

        @Override
        public L1 keyMutations(Stream<Mutation> keyMutations) {
            keyMutations.map(InternalMutation::fromMutation).forEach(this.keyChanges::add);
            return this;
        }

        @Override
        public Builder incrementalKeyList(Id checkpointId, int distanceFromCheckpoint) {
            PersistentBase.checkCalled(this.checkpointId, "incrementalKeyList");
            if (this.fragmentIds != null) {
                throw new UnsupportedOperationException("Cannot call incrementalKeyList after completeKeyList.");
            }
            this.checkpointId = checkpointId;
            this.distanceFromCheckpoint = distanceFromCheckpoint;
            return this;
        }

        @Override
        public Builder completeKeyList(Stream<Id> fragmentIds) {
            PersistentBase.checkCalled(this.fragmentIds, "completeKeyList");
            if (this.checkpointId != null) {
                throw new UnsupportedOperationException("Cannot call completeKeyList after incrementalKeyList.");
            }
            this.fragmentIds = fragmentIds;
            return this;
        }

        @Override
        InternalL1 build() {
            PersistentBase.checkSet(this.metadataId, "metadataId");
            PersistentBase.checkSet(this.children, "children");
            PersistentBase.checkSet(this.ancestors, "ancestors");
            return new InternalL1(this.metadataId, this.children.collect(IdMap.collector(43)), this.id, this.buildKeyList(), ParentList.of(this.ancestors), this.dt);
        }

        private KeyList buildKeyList() {
            if (this.checkpointId != null) {
                return KeyList.incremental(this.checkpointId, this.keyChanges, this.distanceFromCheckpoint);
            }
            if (this.fragmentIds != null) {
                return new KeyList.CompleteList(this.fragmentIds.collect(Collectors.toList()), this.keyChanges);
            }
            throw new IllegalStateException("Neither a checkpoint nor a incremental key list were found.");
        }
    }
}

