/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Objects;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.IdMap;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.L2;

class InternalL2
extends PersistentBase<L2> {
    private static final long HASH_SEED = -6352836103271505167L;
    static final int SIZE = 199;
    static InternalL2 EMPTY = new InternalL2(null, new IdMap(199, InternalL3.EMPTY_ID), 0L);
    static Id EMPTY_ID = EMPTY.getId();
    private final IdMap map;

    private InternalL2(Id id, IdMap map, Long dt) {
        super(id, dt);
        assert (map.size() == 199);
        this.map = map;
    }

    private InternalL2(IdMap map) {
        this(null, map, DT.now());
    }

    Id getId(int position) {
        return this.map.getId(position);
    }

    InternalL2 set(int position, Id l2Id) {
        return new InternalL2(this.map.withId(position, l2Id));
    }

    @Override
    Id generateId() {
        return Id.build(h -> {
            h.putLong(-6352836103271505167L);
            this.map.forEach(id -> h.putBytes(id.getValue().asReadOnlyByteBuffer()));
        });
    }

    int size() {
        int count = 0;
        for (Id id : this.map) {
            if (id.equals(InternalL3.EMPTY_ID)) continue;
            ++count;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalL2 l2 = (InternalL2)o;
        return Objects.equal((Object)this.map, (Object)l2.map);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.map});
    }

    @Override
    L2 applyToConsumer(L2 consumer) {
        return super.applyToConsumer(consumer).children(this.map.stream());
    }

    @Override
    EntityType<L2, InternalL2, Builder> getEntityType() {
        return EntityType.L2;
    }

    static final class Builder
    extends PersistentBase.EntityBuilder<InternalL2, L2>
    implements L2 {
        private Stream<Id> children;

        Builder() {
        }

        @Override
        public Builder children(Stream<Id> ids) {
            PersistentBase.checkCalled(this.children, "children");
            this.children = ids;
            return this;
        }

        @Override
        InternalL2 build() {
            PersistentBase.checkSet(this.children, "children");
            return new InternalL2(this.id, IdMap.of(this.children, 199), this.dt);
        }
    }
}

