/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.condition.ExpressionPath;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExpressionPath.NameSegment", generator="Immutables")
@Immutable
public final class ImmutableNameSegment
extends ExpressionPath.NameSegment {
    @Nullable
    private final ExpressionPath.PathSegment child;
    private final String name;

    private ImmutableNameSegment(@Nullable ExpressionPath.PathSegment child, String name) {
        this.child = child;
        this.name = name;
    }

    @Override
    public Optional<ExpressionPath.PathSegment> getChild() {
        return Optional.ofNullable(this.child);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ImmutableNameSegment withChild(ExpressionPath.PathSegment value) {
        ExpressionPath.PathSegment newValue = Objects.requireNonNull(value, "child");
        if (this.child == newValue) {
            return this;
        }
        return new ImmutableNameSegment(newValue, this.name);
    }

    public final ImmutableNameSegment withChild(Optional<? extends ExpressionPath.PathSegment> optional) {
        ExpressionPath.PathSegment value = optional.orElse(null);
        if (this.child == value) {
            return this;
        }
        return new ImmutableNameSegment(value, this.name);
    }

    public final ImmutableNameSegment withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNameSegment(this.child, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNameSegment && this.equalTo((ImmutableNameSegment)another);
    }

    private boolean equalTo(ImmutableNameSegment another) {
        return Objects.equals(this.child, another.child) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.child);
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NameSegment").omitNullValues().add("child", (Object)this.child).add("name", (Object)this.name).toString();
    }

    public static ImmutableNameSegment copyOf(ExpressionPath.NameSegment instance) {
        if (instance instanceof ImmutableNameSegment) {
            return (ImmutableNameSegment)instance;
        }
        return ImmutableNameSegment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpressionPath.NameSegment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private ExpressionPath.PathSegment child;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionPath.PathSegment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionPath.NameSegment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExpressionPath.PathSegment instance;
            Optional<ExpressionPath.PathSegment> childOptional;
            if (object instanceof ExpressionPath.PathSegment && (childOptional = (instance = (ExpressionPath.PathSegment)object).getChild()).isPresent()) {
                this.child(childOptional);
            }
            if (object instanceof ExpressionPath.NameSegment) {
                instance = (ExpressionPath.NameSegment)object;
                this.name(((ExpressionPath.NameSegment)instance).getName());
            }
        }

        @CanIgnoreReturnValue
        public final Builder child(ExpressionPath.PathSegment child) {
            this.child = Objects.requireNonNull(child, "child");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder child(Optional<? extends ExpressionPath.PathSegment> child) {
            this.child = child.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNameSegment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNameSegment(this.child, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build NameSegment, some of required attributes are not set " + attributes;
        }
    }
}

