/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.condition.ExpressionPath;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExpressionPath.PositionSegment", generator="Immutables")
@Immutable
public final class ImmutablePositionSegment
extends ExpressionPath.PositionSegment {
    @Nullable
    private final ExpressionPath.PathSegment child;
    private final int position;

    private ImmutablePositionSegment(@Nullable ExpressionPath.PathSegment child, int position) {
        this.child = child;
        this.position = position;
    }

    @Override
    public Optional<ExpressionPath.PathSegment> getChild() {
        return Optional.ofNullable(this.child);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public final ImmutablePositionSegment withChild(ExpressionPath.PathSegment value) {
        ExpressionPath.PathSegment newValue = Objects.requireNonNull(value, "child");
        if (this.child == newValue) {
            return this;
        }
        return new ImmutablePositionSegment(newValue, this.position);
    }

    public final ImmutablePositionSegment withChild(Optional<? extends ExpressionPath.PathSegment> optional) {
        ExpressionPath.PathSegment value = optional.orElse(null);
        if (this.child == value) {
            return this;
        }
        return new ImmutablePositionSegment(value, this.position);
    }

    public final ImmutablePositionSegment withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutablePositionSegment(this.child, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePositionSegment && this.equalTo((ImmutablePositionSegment)another);
    }

    private boolean equalTo(ImmutablePositionSegment another) {
        return Objects.equals(this.child, another.child) && this.position == another.position;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.child);
        h += (h << 5) + this.position;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PositionSegment").omitNullValues().add("child", (Object)this.child).add("position", this.position).toString();
    }

    public static ImmutablePositionSegment copyOf(ExpressionPath.PositionSegment instance) {
        if (instance instanceof ImmutablePositionSegment) {
            return (ImmutablePositionSegment)instance;
        }
        return ImmutablePositionSegment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpressionPath.PositionSegment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POSITION = 1L;
        private long initBits = 1L;
        @Nullable
        private ExpressionPath.PathSegment child;
        private int position;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionPath.PathSegment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionPath.PositionSegment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExpressionPath.PathSegment instance;
            Optional<ExpressionPath.PathSegment> childOptional;
            if (object instanceof ExpressionPath.PathSegment && (childOptional = (instance = (ExpressionPath.PathSegment)object).getChild()).isPresent()) {
                this.child(childOptional);
            }
            if (object instanceof ExpressionPath.PositionSegment) {
                instance = (ExpressionPath.PositionSegment)object;
                this.position(((ExpressionPath.PositionSegment)instance).getPosition());
            }
        }

        @CanIgnoreReturnValue
        public final Builder child(ExpressionPath.PathSegment child) {
            this.child = Objects.requireNonNull(child, "child");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder child(Optional<? extends ExpressionPath.PathSegment> child) {
            this.child = child.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePositionSegment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePositionSegment(this.child, this.position);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("position");
            }
            return "Cannot build PositionSegment, some of required attributes are not set " + attributes;
        }
    }
}

