/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.ValueVisitor;
import org.projectnessie.versioned.store.Entity;

public interface Value
extends AliasCollector.Aliasable<Value> {
    public static Value of(Entity value) {
        return new ValueOfEntity(value);
    }

    @Override
    public Value alias(AliasCollector var1);

    public String asString();

    public Type getType();

    public <T> T accept(ValueVisitor<T> var1);

    default public Entity getValue() {
        throw new IllegalArgumentException();
    }

    default public ExpressionPath getPath() {
        throw new IllegalArgumentException();
    }

    default public ExpressionFunction getFunction() {
        throw new IllegalArgumentException();
    }

    public static class ValueOfEntity
    implements Value {
        private final Entity value;

        public ValueOfEntity(Entity value) {
            this.value = value;
        }

        @Override
        public Value alias(AliasCollector c) {
            return ExpressionPath.builder(c.alias(this.value)).build();
        }

        @Override
        public String asString() {
            throw new IllegalArgumentException();
        }

        @Override
        public Type getType() {
            return Type.VALUE;
        }

        @Override
        public Entity getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(ValueVisitor<T> visitor) {
            return visitor.visit(this.value);
        }
    }

    public static enum Type {
        VALUE,
        PATH,
        FUNCTION;

    }
}

