/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Entity {
    private Entity() {
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract EntityType getType();

    public abstract String toString();

    public String getString() {
        throw new IllegalStateException("Not a string.");
    }

    public static Entity ofString(String str) {
        return new StringEntity(str);
    }

    public ByteString getBinary() {
        throw new IllegalStateException("Not a binary value.");
    }

    public static Entity ofBinary(ByteString bytes) {
        return new BinaryEntity(bytes);
    }

    public static Entity ofBinary(byte[] bytes) {
        return new BinaryEntity(ByteString.copyFrom((byte[])bytes));
    }

    public List<Entity> getList() {
        throw new IllegalStateException("Not a list.");
    }

    public static Entity ofList(List<Entity> list) {
        return new ListEntity(list);
    }

    public static Entity ofList(Entity ... entities) {
        return new ListEntity((List<Entity>)ImmutableList.builder().add((Object[])entities).build());
    }

    public static Entity ofList(Stream<Entity> entities) {
        return new ListEntity((List)entities.collect(ImmutableList.toImmutableList()));
    }

    public Map<String, Entity> getMap() {
        throw new IllegalStateException("Not a map.");
    }

    public static Entity ofMap(Map<String, Entity> map) {
        return new MapEntity(map);
    }

    public long getNumber() {
        throw new IllegalStateException("Not a number.");
    }

    public static Entity ofNumber(int number) {
        return new NumberEntity(number);
    }

    public static Entity ofNumber(long number) {
        return new NumberEntity(number);
    }

    public boolean getBoolean() {
        throw new IllegalStateException("Not a boolean value.");
    }

    public static Entity ofBoolean(boolean bool) {
        return new BooleanEntity(bool);
    }

    private static final class BooleanEntity
    extends Entity {
        private final boolean bool;

        public BooleanEntity(boolean bool) {
            this.bool = bool;
        }

        @Override
        public boolean getBoolean() {
            return this.bool;
        }

        @Override
        public EntityType getType() {
            return EntityType.BOOLEAN;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.bool);
        }

        @Override
        public String toString() {
            return Boolean.toString(this.bool);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BooleanEntity)) {
                return false;
            }
            BooleanEntity other = (BooleanEntity)obj;
            return this.bool == other.bool;
        }
    }

    private static final class NumberEntity
    extends Entity {
        private final long number;

        public NumberEntity(long number) {
            this.number = number;
        }

        @Override
        public long getNumber() {
            return this.number;
        }

        @Override
        public EntityType getType() {
            return EntityType.NUMBER;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.number);
        }

        @Override
        public String toString() {
            return "n" + this.number;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NumberEntity)) {
                return false;
            }
            NumberEntity other = (NumberEntity)obj;
            return Objects.equals(this.number, other.number);
        }
    }

    private static final class ListEntity
    extends Entity {
        private final ImmutableList<Entity> list;

        public ListEntity(List<Entity> list) {
            this.list = ImmutableList.copyOf(list);
        }

        @Override
        public List<Entity> getList() {
            return this.list;
        }

        @Override
        public EntityType getType() {
            return EntityType.LIST;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.list);
        }

        @Override
        public String toString() {
            return "[" + this.list.stream().map(Entity::toString).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ListEntity)) {
                return false;
            }
            ListEntity other = (ListEntity)obj;
            return Objects.equals(this.list, other.list);
        }
    }

    private static final class MapEntity
    extends Entity {
        private final ImmutableMap<String, Entity> map;

        public MapEntity(Map<String, Entity> map) {
            this.map = ImmutableMap.copyOf(map);
        }

        @Override
        public Map<String, Entity> getMap() {
            return this.map;
        }

        @Override
        public EntityType getType() {
            return EntityType.MAP;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.map);
        }

        @Override
        public String toString() {
            return "{" + this.map.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining(", ")) + "}";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MapEntity)) {
                return false;
            }
            MapEntity other = (MapEntity)obj;
            return Objects.equals(this.map, other.map);
        }
    }

    private static final class BinaryEntity
    extends Entity {
        private final ByteString binary;

        public BinaryEntity(ByteString b) {
            this.binary = b;
        }

        @Override
        public ByteString getBinary() {
            return this.binary;
        }

        @Override
        public EntityType getType() {
            return EntityType.BINARY;
        }

        @Override
        public String toString() {
            return "b:" + Base64.getEncoder().encodeToString(this.binary.toByteArray());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.binary);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BinaryEntity)) {
                return false;
            }
            BinaryEntity other = (BinaryEntity)obj;
            return Objects.equals(this.binary, other.binary);
        }
    }

    private static final class StringEntity
    extends Entity {
        private final String str;

        public StringEntity(String s) {
            this.str = s;
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public EntityType getType() {
            return EntityType.STRING;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.str);
        }

        @Override
        public String toString() {
            return "\"" + this.str + "\"";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StringEntity)) {
                return false;
            }
            StringEntity other = (StringEntity)obj;
            return Objects.equals(this.str, other.str);
        }
    }

    public static enum EntityType {
        MAP,
        LIST,
        NUMBER,
        STRING,
        BINARY,
        BOOLEAN;

    }
}

