/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.store.Entity;

public final class Id {
    public static final int LENGTH = 20;
    public static final Id EMPTY = new Id(ByteString.copyFrom((byte[])new byte[20]));
    private final ByteString value;

    private Id(ByteString value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.size() == 20 ? 1 : 0) != 0, (String)"Invalid key for this version store. Expected a binary value of length %s but value was actually %s bytes long.", (int)20, (int)value.size());
        this.value = value;
    }

    public ByteString getValue() {
        return this.value;
    }

    public static Id of(byte[] bytes) {
        return Id.of(ByteString.copyFrom((byte[])bytes));
    }

    public static Id of(ByteBuffer bytes) {
        return Id.of(ByteString.copyFrom((ByteBuffer)bytes));
    }

    public static Id of(ByteString bytes) {
        return new Id(bytes);
    }

    public static Id of(Hash hash) throws ReferenceNotFoundException {
        ByteString bytes = hash.asBytes();
        if (bytes.size() != 20) {
            throw ReferenceNotFoundException.forReference((Ref)hash);
        }
        return Id.of(bytes);
    }

    public static Id build(ByteBuffer bytes) {
        return Id.build((Hasher hasher) -> hasher.putBytes(bytes));
    }

    public static Id build(String string) {
        return Id.build((Hasher hasher) -> hasher.putString((CharSequence)string.toLowerCase(Locale.US), StandardCharsets.UTF_8));
    }

    public static Id build(ByteString bytes) {
        return Id.build((Hasher hasher) -> Id.hashByteString(bytes, hasher));
    }

    public static Id build(Consumer<Hasher> consumer) {
        Hasher hasher = Hashing.sha256().newHasher();
        consumer.accept(hasher);
        byte[] outputBytes = hasher.hash().asBytes();
        return new Id(UnsafeByteOperations.unsafeWrap((byte[])outputBytes, (int)0, (int)20));
    }

    public String toString() {
        return this.toHash().asString();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean isNonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Id)) {
            return false;
        }
        Id other = (Id)obj;
        return Objects.equals(this.getValue(), other.getValue());
    }

    public static Id generateRandom() {
        byte[] bytes = new byte[20];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Id.of(bytes);
    }

    public byte[] toBytes() {
        return this.getValue().toByteArray();
    }

    private static void hashByteString(ByteString bytes, final Hasher hasher) {
        try {
            UnsafeByteOperations.unsafeWriteTo((ByteString)bytes, (ByteOutput)new ByteOutput(){

                public void write(byte value) throws IOException {
                    hasher.putByte(value);
                }

                public void write(byte[] value, int offset, int length) throws IOException {
                    hasher.putBytes(value, offset, length);
                }

                public void write(ByteBuffer value) throws IOException {
                    hasher.putBytes(value);
                }

                public void writeLazy(byte[] value, int offset, int length) throws IOException {
                    this.write(value, offset, length);
                }

                public void writeLazy(ByteBuffer value) throws IOException {
                    this.write(value);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Entity toEntity() {
        return Entity.ofBinary(this.getValue());
    }

    public Hash toHash() {
        return Hash.of((ByteString)this.getValue());
    }

    public static Id fromEntity(Entity value) {
        return Id.of(value.getBinary());
    }

    public Id getHash() {
        return this;
    }
}

