/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tiered;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.tiered.Mutation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Mutation.Addition", generator="Immutables")
@Immutable
public final class ImmutableAddition
extends Mutation.Addition {
    private final Key key;
    @Nullable
    private final Byte payload;

    private ImmutableAddition(Key key, @Nullable Byte payload) {
        this.key = key;
        this.payload = payload;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public Byte getPayload() {
        return this.payload;
    }

    public final ImmutableAddition withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableAddition(newValue, this.payload);
    }

    public final ImmutableAddition withPayload(@Nullable Byte value) {
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableAddition(this.key, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddition && this.equalTo((ImmutableAddition)another);
    }

    private boolean equalTo(ImmutableAddition another) {
        return this.key.equals((Object)another.key) && Objects.equals(this.payload, another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.payload);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Addition").omitNullValues().add("key", (Object)this.key).add("payload", (Object)this.payload).toString();
    }

    public static ImmutableAddition copyOf(Mutation.Addition instance) {
        if (instance instanceof ImmutableAddition) {
            return (ImmutableAddition)instance;
        }
        return ImmutableAddition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Mutation.Addition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private Key key;
        @Nullable
        private Byte payload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Mutation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Mutation.Addition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Mutation instance;
            long bits = 0L;
            if (object instanceof Mutation) {
                instance = (Mutation)object;
                if ((bits & 1L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 1L;
                }
            }
            if (object instanceof Mutation.Addition) {
                instance = (Mutation.Addition)object;
                Byte payloadValue = ((Mutation.Addition)instance).getPayload();
                if (payloadValue != null) {
                    this.payload(payloadValue);
                }
                if ((bits & 1L) == 0L) {
                    this.key(((Mutation.Addition)instance).getKey());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(@Nullable Byte payload) {
            this.payload = payload;
            return this;
        }

        public ImmutableAddition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddition(this.key, this.payload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Addition, some of required attributes are not set " + attributes;
        }
    }
}

