/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.projectnessie.versioned.impl.EntitySaveOp;
import org.projectnessie.versioned.impl.InternalCommitMetadata;
import org.projectnessie.versioned.impl.InternalFragment;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalValue;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;
import org.projectnessie.versioned.tiered.CommitMetadata;
import org.projectnessie.versioned.tiered.Fragment;
import org.projectnessie.versioned.tiered.L1;
import org.projectnessie.versioned.tiered.L2;
import org.projectnessie.versioned.tiered.L3;
import org.projectnessie.versioned.tiered.Ref;
import org.projectnessie.versioned.tiered.Value;

final class EntityType<C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> {
    private static final Map<ValueType<?>, EntityType<?, ?, ?>> BY_VALUE_TYPE = new HashMap();
    static final EntityType<Ref, InternalRef, InternalRef.Builder<?>> REF = new EntityType(ValueType.REF, InternalRef.Builder::new);
    static final EntityType<L1, InternalL1, InternalL1.Builder> L1 = new EntityType(ValueType.L1, InternalL1.Builder::new);
    static final EntityType<L2, InternalL2, InternalL2.Builder> L2 = new EntityType(ValueType.L2, InternalL2.Builder::new);
    static final EntityType<L3, InternalL3, InternalL3.Builder> L3 = new EntityType(ValueType.L3, InternalL3.Builder::new);
    static final EntityType<Value, InternalValue, InternalValue.Builder> VALUE = new EntityType(ValueType.VALUE, InternalValue.Builder::new);
    static final EntityType<Fragment, InternalFragment, InternalFragment.Builder> KEY_FRAGMENT = new EntityType(ValueType.KEY_FRAGMENT, InternalFragment.Builder::new);
    static final EntityType<CommitMetadata, InternalCommitMetadata, InternalCommitMetadata.Builder> COMMIT_METADATA = new EntityType(ValueType.COMMIT_METADATA, InternalCommitMetadata.Builder::new);
    final ValueType<C> valueType;
    final Supplier<B> producerSupplier;

    private EntityType(ValueType<C> valueType, Supplier<B> producerSupplier) {
        if (!valueType.getValueClass().isInstance(producerSupplier.get())) {
            throw new IllegalStateException("While you can't formally expose a value instance as the subclass of two separate generic parameters, this class does so internally. The builders provided must be of both C and B types.");
        }
        this.valueType = valueType;
        this.producerSupplier = producerSupplier;
        BY_VALUE_TYPE.put(valueType, this);
    }

    static <C extends BaseValue<C>, E extends PersistentBase<C>, B extends PersistentBase.EntityBuilder<E, C>> EntityType<C, E, B> forType(ValueType<C> type) {
        return BY_VALUE_TYPE.get(type);
    }

    E loadSingle(Store store, Id id) {
        return this.buildEntity(consumer -> store.loadSingle(this.valueType, id, consumer));
    }

    SaveOp<C> createSaveOpForEntity(E value) {
        return new EntitySaveOp<C, E>(this.valueType, value);
    }

    B newEntityProducer() {
        return (B)((PersistentBase.EntityBuilder)this.producerSupplier.get());
    }

    E buildEntity(Consumer<C> producerConsumer) {
        B producer = this.newEntityProducer();
        producerConsumer.accept(producer);
        return (E)((PersistentBase)((PersistentBase.EntityBuilder)producer).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityType that = (EntityType)o;
        return this.valueType == that.valueType;
    }

    public int hashCode() {
        return this.valueType.hashCode();
    }

    public String toString() {
        return "EntityType{valueType=" + this.valueType + '}';
    }
}

