/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.PositionDelta;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;

class IdMap
implements Iterable<Id> {
    private final PositionDelta[] deltas;

    private IdMap(PositionDelta[] deltas) {
        this.deltas = deltas;
    }

    IdMap(int size) {
        this(size, Id.EMPTY);
    }

    IdMap(int size, Id fill) {
        this.deltas = new PositionDelta[size];
        for (int i = 0; i < size; ++i) {
            this.deltas[i] = PositionDelta.builder().oldId(fill).newId(fill).position(i).build();
        }
    }

    public Id getId(int position) {
        this.check(position);
        return this.deltas[position].getNewId();
    }

    private void check(int position) {
        Preconditions.checkPositionIndex((int)position, (int)this.deltas.length);
    }

    public IdMap withId(int position, Id newId) {
        this.check(position);
        PositionDelta[] newDeltas = new PositionDelta[this.deltas.length];
        System.arraycopy(this.deltas, 0, newDeltas, 0, this.deltas.length);
        newDeltas[position] = PositionDelta.builder().from(newDeltas[position]).newId(newId).build();
        return new IdMap(newDeltas);
    }

    public int size() {
        return this.deltas.length;
    }

    public Stream<Id> stream() {
        return Arrays.stream(this.deltas).map(PositionDelta::getNewId);
    }

    @Override
    public Iterator<Id> iterator() {
        return Iterators.unmodifiableIterator(Arrays.stream(this.deltas).map(PositionDelta::getNewId).iterator());
    }

    List<PositionDelta> getChanges() {
        return Arrays.stream(this.deltas).filter(PositionDelta::isDirty).collect(Collectors.toList());
    }

    Entity toEntity() {
        return Entity.ofList((List)Arrays.stream(this.deltas).map(p -> p.getNewId().toEntity()).collect(ImmutableList.toImmutableList()));
    }

    public static IdMap fromEntity(Entity value, int size) {
        PositionDelta[] deltas = new PositionDelta[size];
        List<Entity> items = value.getList();
        Preconditions.checkArgument((items.size() == size ? 1 : 0) != 0, (String)"Expected size %s but actual size was %s.", (int)size, (int)items.size());
        int i = 0;
        for (Entity v : items) {
            deltas[i] = PositionDelta.of(i, Id.fromEntity(v));
            ++i;
        }
        return new IdMap(deltas);
    }

    public static IdMap of(Stream<Id> children, int expectedSize) {
        AtomicInteger counter = new AtomicInteger();
        PositionDelta[] deltas = (PositionDelta[])children.map(id -> PositionDelta.of(counter.getAndIncrement(), id)).toArray(PositionDelta[]::new);
        if (deltas.length != expectedSize) {
            throw new IllegalStateException("Must collect exactly " + expectedSize + " Id elements, but got " + deltas.length);
        }
        return new IdMap(deltas);
    }

    public static IdMap of(List<Id> children, int expectedSize) {
        int sz = children.size();
        PositionDelta[] deltas = new PositionDelta[sz];
        if (sz != expectedSize) {
            throw new IllegalStateException("Must collect exactly " + expectedSize + " Id elements, but got " + sz);
        }
        for (int i = 0; i < sz; ++i) {
            Id id = children.get(i);
            deltas[i] = PositionDelta.of(i, id);
        }
        return new IdMap(deltas);
    }

    public int hashCode() {
        return Arrays.hashCode(this.deltas);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdMap)) {
            return false;
        }
        IdMap other = (IdMap)obj;
        return Arrays.equals(this.deltas, other.deltas);
    }

    public static Collector<Id, List<Id>, IdMap> collector(final int expectedSize) {
        return new Collector<Id, List<Id>, IdMap>(){

            @Override
            public Supplier<List<Id>> supplier() {
                return ArrayList::new;
            }

            @Override
            public BiConsumer<List<Id>, Id> accumulator() {
                return List::add;
            }

            @Override
            public BinaryOperator<List<Id>> combiner() {
                return (l1, l2) -> {
                    l1.addAll(l2);
                    return l1;
                };
            }

            @Override
            public Function<List<Id>, IdMap> finisher() {
                return l -> IdMap.of(l, expectedSize);
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.noneOf(Collector.Characteristics.class);
            }
        };
    }
}

