/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.PositionDelta;
import org.projectnessie.versioned.impl.PositionDeltaWithPayload;
import org.projectnessie.versioned.store.Id;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PositionDeltaWithPayload", generator="Immutables")
@Immutable
final class ImmutablePositionDeltaWithPayload
extends PositionDeltaWithPayload {
    private final int position;
    private final Id oldId;
    private final Id newId;
    @Nullable
    private final Byte oldPayload;
    @Nullable
    private final Byte newPayload;

    private ImmutablePositionDeltaWithPayload(int position, Id oldId, Id newId, @Nullable Byte oldPayload, @Nullable Byte newPayload) {
        this.position = position;
        this.oldId = oldId;
        this.newId = newId;
        this.oldPayload = oldPayload;
        this.newPayload = newPayload;
    }

    @Override
    int getPosition() {
        return this.position;
    }

    @Override
    Id getOldId() {
        return this.oldId;
    }

    @Override
    Id getNewId() {
        return this.newId;
    }

    @Override
    @Nullable
    Byte getOldPayload() {
        return this.oldPayload;
    }

    @Override
    @Nullable
    Byte getNewPayload() {
        return this.newPayload;
    }

    public final ImmutablePositionDeltaWithPayload withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutablePositionDeltaWithPayload(value, this.oldId, this.newId, this.oldPayload, this.newPayload);
    }

    public final ImmutablePositionDeltaWithPayload withOldId(Id value) {
        if (this.oldId == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "oldId");
        return new ImmutablePositionDeltaWithPayload(this.position, newValue, this.newId, this.oldPayload, this.newPayload);
    }

    public final ImmutablePositionDeltaWithPayload withNewId(Id value) {
        if (this.newId == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "newId");
        return new ImmutablePositionDeltaWithPayload(this.position, this.oldId, newValue, this.oldPayload, this.newPayload);
    }

    public final ImmutablePositionDeltaWithPayload withOldPayload(@Nullable Byte value) {
        if (Objects.equals(this.oldPayload, value)) {
            return this;
        }
        return new ImmutablePositionDeltaWithPayload(this.position, this.oldId, this.newId, value, this.newPayload);
    }

    public final ImmutablePositionDeltaWithPayload withNewPayload(@Nullable Byte value) {
        if (Objects.equals(this.newPayload, value)) {
            return this;
        }
        return new ImmutablePositionDeltaWithPayload(this.position, this.oldId, this.newId, this.oldPayload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePositionDeltaWithPayload && this.equalTo((ImmutablePositionDeltaWithPayload)another);
    }

    private boolean equalTo(ImmutablePositionDeltaWithPayload another) {
        return this.position == another.position && this.newId.equals(another.newId) && Objects.equals(this.newPayload, another.newPayload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.position;
        h += (h << 5) + this.newId.hashCode();
        h += (h << 5) + Objects.hashCode(this.newPayload);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PositionDeltaWithPayload").omitNullValues().add("position", this.position).add("newId", (Object)this.newId).add("newPayload", (Object)this.newPayload).toString();
    }

    public static ImmutablePositionDeltaWithPayload copyOf(PositionDeltaWithPayload instance) {
        if (instance instanceof ImmutablePositionDeltaWithPayload) {
            return (ImmutablePositionDeltaWithPayload)instance;
        }
        return ImmutablePositionDeltaWithPayload.getBuilder().from(instance).build();
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Generated(from="PositionDeltaWithPayload", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POSITION = 1L;
        private static final long INIT_BIT_OLD_ID = 2L;
        private static final long INIT_BIT_NEW_ID = 4L;
        private long initBits = 7L;
        private int position;
        @Nullable
        private Id oldId;
        @Nullable
        private Id newId;
        @Nullable
        private Byte oldPayload;
        @Nullable
        private Byte newPayload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PositionDelta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PositionDeltaWithPayload instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PositionDelta instance;
            if (object instanceof PositionDelta) {
                instance = (PositionDelta)object;
                this.oldId(instance.getOldId());
                this.newId(instance.getNewId());
                this.position(instance.getPosition());
            }
            if (object instanceof PositionDeltaWithPayload) {
                Byte oldPayloadValue;
                instance = (PositionDeltaWithPayload)object;
                Byte newPayloadValue = ((PositionDeltaWithPayload)instance).getNewPayload();
                if (newPayloadValue != null) {
                    this.newPayload(newPayloadValue);
                }
                if ((oldPayloadValue = ((PositionDeltaWithPayload)instance).getOldPayload()) != null) {
                    this.oldPayload(oldPayloadValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oldId(Id oldId) {
            this.oldId = Objects.requireNonNull(oldId, "oldId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newId(Id newId) {
            this.newId = Objects.requireNonNull(newId, "newId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oldPayload(@Nullable Byte oldPayload) {
            this.oldPayload = oldPayload;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newPayload(@Nullable Byte newPayload) {
            this.newPayload = newPayload;
            return this;
        }

        public ImmutablePositionDeltaWithPayload build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePositionDeltaWithPayload(this.position, this.oldId, this.newId, this.oldPayload, this.newPayload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("position");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("oldId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("newId");
            }
            return "Cannot build PositionDeltaWithPayload, some of required attributes are not set " + attributes;
        }
    }
}

