/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TieredVersionStoreConfig", generator="Immutables")
@Immutable
public final class ImmutableTieredVersionStoreConfig
implements TieredVersionStoreConfig {
    private final int commitAttempts;
    private final int p2CommitAttempts;
    private final boolean waitOnCollapse;
    private final boolean enableTracing;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTieredVersionStoreConfig(Builder builder) {
        if (builder.commitAttemptsIsSet()) {
            this.initShim.commitAttempts(builder.commitAttempts);
        }
        if (builder.p2CommitAttemptsIsSet()) {
            this.initShim.p2CommitAttempts(builder.p2CommitAttempts);
        }
        if (builder.waitOnCollapseIsSet()) {
            this.initShim.waitOnCollapse(builder.waitOnCollapse);
        }
        if (builder.enableTracingIsSet()) {
            this.initShim.enableTracing(builder.enableTracing);
        }
        this.commitAttempts = this.initShim.getCommitAttempts();
        this.p2CommitAttempts = this.initShim.getP2CommitAttempts();
        this.waitOnCollapse = this.initShim.waitOnCollapse();
        this.enableTracing = this.initShim.enableTracing();
        this.initShim = null;
    }

    private ImmutableTieredVersionStoreConfig(int commitAttempts, int p2CommitAttempts, boolean waitOnCollapse, boolean enableTracing) {
        this.commitAttempts = commitAttempts;
        this.p2CommitAttempts = p2CommitAttempts;
        this.waitOnCollapse = waitOnCollapse;
        this.enableTracing = enableTracing;
        this.initShim = null;
    }

    private int getCommitAttemptsInitialize() {
        return TieredVersionStoreConfig.super.getCommitAttempts();
    }

    private int getP2CommitAttemptsInitialize() {
        return TieredVersionStoreConfig.super.getP2CommitAttempts();
    }

    private boolean waitOnCollapseInitialize() {
        return TieredVersionStoreConfig.super.waitOnCollapse();
    }

    private boolean enableTracingInitialize() {
        return TieredVersionStoreConfig.super.enableTracing();
    }

    @Override
    public int getCommitAttempts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitAttempts() : this.commitAttempts;
    }

    @Override
    public int getP2CommitAttempts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getP2CommitAttempts() : this.p2CommitAttempts;
    }

    @Override
    public boolean waitOnCollapse() {
        InitShim shim = this.initShim;
        return shim != null ? shim.waitOnCollapse() : this.waitOnCollapse;
    }

    @Override
    public boolean enableTracing() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableTracing() : this.enableTracing;
    }

    public final ImmutableTieredVersionStoreConfig withCommitAttempts(int value) {
        if (this.commitAttempts == value) {
            return this;
        }
        return new ImmutableTieredVersionStoreConfig(value, this.p2CommitAttempts, this.waitOnCollapse, this.enableTracing);
    }

    public final ImmutableTieredVersionStoreConfig withP2CommitAttempts(int value) {
        if (this.p2CommitAttempts == value) {
            return this;
        }
        return new ImmutableTieredVersionStoreConfig(this.commitAttempts, value, this.waitOnCollapse, this.enableTracing);
    }

    public final ImmutableTieredVersionStoreConfig withWaitOnCollapse(boolean value) {
        if (this.waitOnCollapse == value) {
            return this;
        }
        return new ImmutableTieredVersionStoreConfig(this.commitAttempts, this.p2CommitAttempts, value, this.enableTracing);
    }

    public final ImmutableTieredVersionStoreConfig withEnableTracing(boolean value) {
        if (this.enableTracing == value) {
            return this;
        }
        return new ImmutableTieredVersionStoreConfig(this.commitAttempts, this.p2CommitAttempts, this.waitOnCollapse, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTieredVersionStoreConfig && this.equalTo((ImmutableTieredVersionStoreConfig)another);
    }

    private boolean equalTo(ImmutableTieredVersionStoreConfig another) {
        return this.commitAttempts == another.commitAttempts && this.p2CommitAttempts == another.p2CommitAttempts && this.waitOnCollapse == another.waitOnCollapse && this.enableTracing == another.enableTracing;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commitAttempts;
        h += (h << 5) + this.p2CommitAttempts;
        h += (h << 5) + Booleans.hashCode((boolean)this.waitOnCollapse);
        h += (h << 5) + Booleans.hashCode((boolean)this.enableTracing);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TieredVersionStoreConfig").omitNullValues().add("commitAttempts", this.commitAttempts).add("p2CommitAttempts", this.p2CommitAttempts).add("waitOnCollapse", this.waitOnCollapse).add("enableTracing", this.enableTracing).toString();
    }

    public static ImmutableTieredVersionStoreConfig copyOf(TieredVersionStoreConfig instance) {
        if (instance instanceof ImmutableTieredVersionStoreConfig) {
            return (ImmutableTieredVersionStoreConfig)instance;
        }
        return ImmutableTieredVersionStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TieredVersionStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_COMMIT_ATTEMPTS = 1L;
        private static final long OPT_BIT_P2_COMMIT_ATTEMPTS = 2L;
        private static final long OPT_BIT_WAIT_ON_COLLAPSE = 4L;
        private static final long OPT_BIT_ENABLE_TRACING = 8L;
        private long optBits;
        private int commitAttempts;
        private int p2CommitAttempts;
        private boolean waitOnCollapse;
        private boolean enableTracing;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TieredVersionStoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.commitAttempts(instance.getCommitAttempts());
            this.p2CommitAttempts(instance.getP2CommitAttempts());
            this.waitOnCollapse(instance.waitOnCollapse());
            this.enableTracing(instance.enableTracing());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitAttempts(int commitAttempts) {
            this.commitAttempts = commitAttempts;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder p2CommitAttempts(int p2CommitAttempts) {
            this.p2CommitAttempts = p2CommitAttempts;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder waitOnCollapse(boolean waitOnCollapse) {
            this.waitOnCollapse = waitOnCollapse;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableTracing(boolean enableTracing) {
            this.enableTracing = enableTracing;
            this.optBits |= 8L;
            return this;
        }

        public ImmutableTieredVersionStoreConfig build() {
            return new ImmutableTieredVersionStoreConfig(this);
        }

        private boolean commitAttemptsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean p2CommitAttemptsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean waitOnCollapseIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean enableTracingIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="TieredVersionStoreConfig", generator="Immutables")
    private final class InitShim {
        private byte commitAttemptsBuildStage = 0;
        private int commitAttempts;
        private byte p2CommitAttemptsBuildStage = 0;
        private int p2CommitAttempts;
        private byte waitOnCollapseBuildStage = 0;
        private boolean waitOnCollapse;
        private byte enableTracingBuildStage = 0;
        private boolean enableTracing;

        private InitShim() {
        }

        int getCommitAttempts() {
            if (this.commitAttemptsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitAttemptsBuildStage == 0) {
                this.commitAttemptsBuildStage = (byte)-1;
                this.commitAttempts = ImmutableTieredVersionStoreConfig.this.getCommitAttemptsInitialize();
                this.commitAttemptsBuildStage = 1;
            }
            return this.commitAttempts;
        }

        void commitAttempts(int commitAttempts) {
            this.commitAttempts = commitAttempts;
            this.commitAttemptsBuildStage = 1;
        }

        int getP2CommitAttempts() {
            if (this.p2CommitAttemptsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.p2CommitAttemptsBuildStage == 0) {
                this.p2CommitAttemptsBuildStage = (byte)-1;
                this.p2CommitAttempts = ImmutableTieredVersionStoreConfig.this.getP2CommitAttemptsInitialize();
                this.p2CommitAttemptsBuildStage = 1;
            }
            return this.p2CommitAttempts;
        }

        void p2CommitAttempts(int p2CommitAttempts) {
            this.p2CommitAttempts = p2CommitAttempts;
            this.p2CommitAttemptsBuildStage = 1;
        }

        boolean waitOnCollapse() {
            if (this.waitOnCollapseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.waitOnCollapseBuildStage == 0) {
                this.waitOnCollapseBuildStage = (byte)-1;
                this.waitOnCollapse = ImmutableTieredVersionStoreConfig.this.waitOnCollapseInitialize();
                this.waitOnCollapseBuildStage = 1;
            }
            return this.waitOnCollapse;
        }

        void waitOnCollapse(boolean waitOnCollapse) {
            this.waitOnCollapse = waitOnCollapse;
            this.waitOnCollapseBuildStage = 1;
        }

        boolean enableTracing() {
            if (this.enableTracingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableTracingBuildStage == 0) {
                this.enableTracingBuildStage = (byte)-1;
                this.enableTracing = ImmutableTieredVersionStoreConfig.this.enableTracingInitialize();
                this.enableTracingBuildStage = 1;
            }
            return this.enableTracing;
        }

        void enableTracing(boolean enableTracing) {
            this.enableTracing = enableTracing;
            this.enableTracingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commitAttemptsBuildStage == -1) {
                attributes.add("commitAttempts");
            }
            if (this.p2CommitAttemptsBuildStage == -1) {
                attributes.add("p2CommitAttempts");
            }
            if (this.waitOnCollapseBuildStage == -1) {
                attributes.add("waitOnCollapse");
            }
            if (this.enableTracingBuildStage == -1) {
                attributes.add("enableTracing");
            }
            return "Cannot build TieredVersionStoreConfig, attribute initializers form cycle " + attributes;
        }
    }
}

