/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.store.Id;

public class InconsistentValue {
    private final Key key;
    private final Optional<Id> expected;
    private final Optional<Id> actual;

    InconsistentValue(Key key, Optional<Id> expected, Optional<Id> actual) {
        this.key = key;
        this.expected = expected;
        this.actual = actual;
    }

    public Key getKey() {
        return this.key;
    }

    public Optional<Id> getExpected() {
        return this.expected;
    }

    public Optional<Id> getActual() {
        return this.actual;
    }

    public static class InconsistentValueException
    extends ReferenceConflictException {
        private static final long serialVersionUID = -1983826821815886489L;
        private final List<InconsistentValue> inconsistentValues;

        public InconsistentValueException(List<InconsistentValue> inconsistentValues) {
            super(String.format("Unable to complete operation. Found %d inconsistent value(s).", inconsistentValues.size()));
            this.inconsistentValues = ImmutableList.copyOf(inconsistentValues);
        }

        public List<InconsistentValue> getInconsistentValues() {
            return this.inconsistentValues;
        }
    }
}

