/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMapDifference;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.ImmutableKey;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.DiffFinder;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.PositionDeltaWithPayload;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.KeyDelta;
import org.projectnessie.versioned.tiered.L3;

class InternalL3
extends PersistentBase<L3> {
    private static final long HASH_SEED = 4604180344422375655L;
    private final TreeMap<InternalKey, PositionDeltaWithPayload> map;
    static InternalL3 EMPTY = new InternalL3(new TreeMap<InternalKey, PositionDeltaWithPayload>());
    static Id EMPTY_ID = EMPTY.getId();

    private InternalL3(TreeMap<InternalKey, PositionDeltaWithPayload> keys) {
        this(null, keys, DT.now());
    }

    private InternalL3(Id id, TreeMap<InternalKey, PositionDeltaWithPayload> keys, Long dt) {
        super(id, dt);
        this.map = keys;
        this.ensureConsistentId();
    }

    Id getId(InternalKey key) {
        PositionDeltaWithPayload delta = this.map.get(key);
        if (delta == null) {
            return Id.EMPTY;
        }
        return delta.getNewId();
    }

    Optional<Id> getPossibleId(InternalKey key) {
        Id id = this.getId(key);
        if (Id.EMPTY.equals(id)) {
            return Optional.empty();
        }
        return Optional.of(id);
    }

    InternalL3 set(InternalKey key, Id valueId, Byte payload) {
        TreeMap newMap = (TreeMap)this.map.clone();
        PositionDeltaWithPayload newDelta = (PositionDeltaWithPayload)newMap.get(key);
        if (newDelta == null) {
            newDelta = PositionDeltaWithPayload.SINGLE_ZERO;
        }
        if (!(newDelta = PositionDeltaWithPayload.builderWithPayload().from(newDelta).newId(valueId).newPayload(payload).build()).isDirty()) {
            newMap.remove(key);
        } else {
            newMap.put(key, newDelta);
        }
        return new InternalL3(newMap);
    }

    @Override
    Id generateId() {
        return Id.build(hasher -> {
            hasher.putLong(4604180344422375655L);
            this.map.forEach((key, delta) -> {
                if (delta.getNewId().isEmpty()) {
                    return;
                }
                InternalKey.addToHasher(key, hasher);
                hasher.putBytes(delta.getNewId().getValue().asReadOnlyByteBuffer());
            });
        });
    }

    Stream<InternalMutation> getMutations() {
        return this.map.entrySet().stream().filter(e -> ((PositionDeltaWithPayload)e.getValue()).isDirty()).flatMap(e -> {
            PositionDeltaWithPayload d = (PositionDeltaWithPayload)e.getValue();
            if (d.wasAdded()) {
                return Stream.of(InternalMutation.InternalAddition.of((InternalKey)e.getKey(), d.getNewPayload()));
            }
            if (d.wasRemoved()) {
                return Stream.of(InternalMutation.InternalRemoval.of((InternalKey)e.getKey()));
            }
            if (((PositionDeltaWithPayload)e.getValue()).isPayloadDirty()) {
                return Stream.of(InternalMutation.InternalRemoval.of((InternalKey)e.getKey()), InternalMutation.InternalAddition.of((InternalKey)e.getKey(), d.getNewPayload()));
            }
            return Stream.of(new InternalMutation[0]);
        });
    }

    Stream<InternalKey> getKeys() {
        return this.map.keySet().stream();
    }

    int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalL3 l3 = (InternalL3)o;
        return Objects.equal(this.map, l3.map);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.map});
    }

    @Override
    L3 applyToConsumer(L3 consumer) {
        super.applyToConsumer(consumer);
        Stream<KeyDelta> keyDelta = this.map.entrySet().stream().filter(e -> !((PositionDeltaWithPayload)e.getValue()).getNewId().isEmpty()).map(e -> KeyDelta.of(((InternalKey)e.getKey()).toKey(), ((PositionDeltaWithPayload)e.getValue()).getNewId(), ((PositionDeltaWithPayload)e.getValue()).getNewPayload()));
        consumer.keyDelta(keyDelta);
        return consumer;
    }

    public static Stream<DiffFinder.KeyDiff> compare(InternalL3 from, InternalL3 to) {
        SortedMapDifference difference = Maps.difference((SortedMap)Maps.transformValues(from.map, p -> p.getNewId()), (Map)Maps.transformValues(to.map, p -> p.getNewId()));
        return Stream.concat(difference.entriesDiffering().entrySet().stream().map(DiffFinder.KeyDiff::new), Stream.concat(difference.entriesOnlyOnLeft().entrySet().stream().map(DiffFinder.KeyDiff::onlyOnLeft), difference.entriesOnlyOnRight().entrySet().stream().map(DiffFinder.KeyDiff::onlyOnRight)));
    }

    @Override
    EntityType<L3, InternalL3, Builder> getEntityType() {
        return EntityType.L3;
    }

    static final class Builder
    extends PersistentBase.EntityBuilder<InternalL3, L3>
    implements L3 {
        private Stream<KeyDelta> keyDelta;

        Builder() {
        }

        @Override
        public Builder keyDelta(Stream<KeyDelta> keyDelta) {
            PersistentBase.checkCalled(this.keyDelta, "keyDelta");
            this.keyDelta = keyDelta;
            return this;
        }

        @Override
        InternalL3 build() {
            PersistentBase.checkSet(this.keyDelta, "keyDelta");
            return new InternalL3(this.id, this.keyDelta.collect(Collectors.toMap(kd -> new InternalKey((Key)ImmutableKey.builder().addAllElements((Iterable)kd.getKey().getElements()).build()), kd -> PositionDeltaWithPayload.of(0, kd.getId(), kd.getPayload()), (a, b) -> {
                throw new IllegalArgumentException(String.format("Got Id %s and %s for same key", a.getNewId(), b.getNewId()));
            }, TreeMap::new)), this.dt);
        }
    }
}

