/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.ImmutableInternalAddition;
import org.projectnessie.versioned.impl.ImmutableInternalRemoval;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.tiered.Mutation;

abstract class InternalMutation {
    private static final char ZERO_BYTE = '\u0000';

    InternalMutation() {
    }

    abstract InternalKey getKey();

    abstract MutationType getType();

    static InternalMutation fromMutation(Mutation km) {
        switch (km.getType()) {
            case ADDITION: {
                Mutation.Addition a = (Mutation.Addition)km;
                return InternalAddition.of(new InternalKey(a.getKey()), a.getPayload());
            }
            case REMOVAL: {
                return InternalRemoval.of(new InternalKey(km.getKey()));
            }
        }
        throw new IllegalArgumentException("Unknown mutation-type " + (Object)((Object)km.getType()));
    }

    abstract Mutation toMutation();

    abstract Entity toEntity();

    @Value.Immutable
    public static abstract class InternalRemoval
    extends InternalMutation {
        @Override
        public final MutationType getType() {
            return MutationType.REMOVAL;
        }

        public static InternalRemoval of(InternalKey key) {
            return ImmutableInternalRemoval.builder().key(key).build();
        }

        @Override
        Mutation toMutation() {
            return Mutation.Removal.of(this.getKey().toKey());
        }

        @Override
        public Entity toEntity() {
            Entity key = this.getKey().toEntity();
            Entity payload = Entity.ofString(Character.toString('\u0000'));
            return Entity.ofMap((Map<String, Entity>)ImmutableMap.of((Object)this.getType().field, (Object)Entity.ofList(Stream.concat(Stream.of(payload), key.getList().stream()))));
        }
    }

    @Value.Immutable
    public static abstract class InternalAddition
    extends InternalMutation {
        @Override
        public final MutationType getType() {
            return MutationType.ADDITION;
        }

        public static InternalAddition of(InternalKey key, Byte payload) {
            return ImmutableInternalAddition.builder().key(key).payload(payload).build();
        }

        @Nullable
        public abstract Byte getPayload();

        @Override
        Mutation toMutation() {
            return Mutation.Addition.of(this.getKey().toKey(), this.getPayload());
        }

        @Override
        public Entity toEntity() {
            Entity key = this.getKey().toEntity();
            Entity payload = Entity.ofString(this.getPayload() == null ? Character.toString('\u0000') : this.getPayload().toString());
            return Entity.ofMap((Map<String, Entity>)ImmutableMap.of((Object)this.getType().field, (Object)Entity.ofList(Stream.concat(Stream.of(payload), key.getList().stream()))));
        }
    }

    static enum MutationType {
        ADDITION("a"),
        REMOVAL("d");

        private final String field;

        private MutationType(String field) {
            this.field = field;
        }
    }
}

