/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.IdMap;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.impl.InternalTag;
import org.projectnessie.versioned.impl.KeyMutationList;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.Mutation;
import org.projectnessie.versioned.tiered.Ref;

abstract class InternalRef
extends PersistentBase<Ref> {
    static final String TYPE = "type";

    InternalRef(Id id, Long dt) {
        super(id, dt);
    }

    abstract Type getType();

    InternalBranch getBranch() {
        throw new IllegalArgumentException(String.format("%s cannot be treated as a branch.", this.getClass().getName()));
    }

    InternalTag getTag() {
        throw new IllegalArgumentException(String.format("%s cannot be treated as a tag.", this.getClass().getName()));
    }

    @Override
    <E extends PersistentBase<Ref>> EntityType<Ref, E, ?> getEntityType() {
        return EntityType.REF;
    }

    static class Builder<REF extends InternalRef>
    extends PersistentBase.EntityBuilder<InternalRef, Ref>
    implements Ref {
        private Id id;
        private String name;
        private Builder<REF> typed;

        Builder() {
        }

        @Override
        public Builder<REF> id(Id id) {
            PersistentBase.checkCalled(this.id, "id");
            this.id = id;
            return this;
        }

        @Override
        public Ref.Tag tag() {
            TagBuilder b;
            if (this.typed != null) {
                throw new IllegalStateException("Must only call tag() or branch() once.");
            }
            this.typed = b = new TagBuilder();
            return b;
        }

        @Override
        public Ref.Branch branch() {
            BranchBuilder b;
            if (this.typed != null) {
                throw new IllegalStateException("Must only call tag() or branch() once.");
            }
            this.typed = b = new BranchBuilder();
            return b;
        }

        @Override
        public Builder<REF> name(String name) {
            PersistentBase.checkCalled(this.name, "name");
            this.name = name;
            return this;
        }

        @Override
        REF build() {
            if (this.typed == null) {
                throw new IllegalStateException("Must call tag() or branch() before build().");
            }
            return (REF)this.typed.build();
        }

        private class BranchBuilder
        extends Builder<InternalBranch>
        implements Ref.Branch {
            private Id metadata;
            private Stream<Id> children;
            private List<InternalBranch.Commit> commits;

            private BranchBuilder() {
            }

            @Override
            public Ref.Branch metadata(Id metadata) {
                PersistentBase.checkCalled(this.metadata, "metadata");
                this.metadata = metadata;
                return this;
            }

            @Override
            public Ref.Branch children(Stream<Id> children) {
                PersistentBase.checkCalled(this.children, "children");
                this.children = children;
                return this;
            }

            @Override
            public Ref.Branch commits(Consumer<Ref.BranchCommit> commits) {
                PersistentBase.checkCalled(this.commits, "commits");
                this.commits = new ArrayList<InternalBranch.Commit>();
                commits.accept(new InternalBranchCommit());
                return this;
            }

            @Override
            public Ref backToRef() {
                return Builder.this;
            }

            @Override
            InternalBranch build() {
                PersistentBase.checkSet(Builder.this.name, "name");
                PersistentBase.checkSet(this.metadata, "metadata");
                PersistentBase.checkSet(this.children, "children");
                PersistentBase.checkSet(this.commits, "commits");
                return new InternalBranch(Builder.this.id, Builder.this.name, IdMap.of(this.children, 43), this.metadata, this.commits, this.dt);
            }

            private class InternalBranchCommit
            implements Ref.BranchCommit,
            Ref.SavedCommit,
            Ref.UnsavedCommitDelta,
            Ref.UnsavedCommitMutations {
                private Id id;
                private Id commit;
                private Id parent;
                private List<InternalBranch.UnsavedDelta> unsavedDeltas = new ArrayList<InternalBranch.UnsavedDelta>();
                private List<InternalMutation> keyMutations = new ArrayList<InternalMutation>();

                private InternalBranchCommit() {
                }

                @Override
                public Ref.BranchCommit done() {
                    if (this.parent != null) {
                        BranchBuilder.this.commits.add(new InternalBranch.Commit(this.id, this.commit, this.parent));
                    } else {
                        BranchBuilder.this.commits.add(new InternalBranch.Commit(this.id, this.commit, this.unsavedDeltas, KeyMutationList.of(this.keyMutations)));
                    }
                    this.id = null;
                    this.commit = null;
                    this.parent = null;
                    this.unsavedDeltas = new ArrayList<InternalBranch.UnsavedDelta>();
                    this.keyMutations = new ArrayList<InternalMutation>();
                    return this;
                }

                @Override
                public Ref.BranchCommit id(Id id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Ref.BranchCommit commit(Id commit) {
                    this.commit = commit;
                    return this;
                }

                @Override
                public Ref.SavedCommit saved() {
                    return this;
                }

                @Override
                public Ref.UnsavedCommitDelta unsaved() {
                    return this;
                }

                @Override
                public Ref.SavedCommit parent(Id parent) {
                    this.parent = parent;
                    return this;
                }

                @Override
                public Ref.UnsavedCommitDelta delta(int position, Id oldId, Id newId) {
                    this.unsavedDeltas.add(new InternalBranch.UnsavedDelta(position, oldId, newId));
                    return this;
                }

                @Override
                public Ref.UnsavedCommitMutations mutations() {
                    return this;
                }

                @Override
                public Ref.UnsavedCommitMutations keyMutation(Mutation keyMutation) {
                    this.keyMutations.add(InternalMutation.fromMutation(keyMutation));
                    return this;
                }
            }
        }

        private class TagBuilder
        extends Builder<InternalTag>
        implements Ref.Tag {
            private Id commit;

            private TagBuilder() {
            }

            @Override
            public Ref.Tag commit(Id commit) {
                PersistentBase.checkCalled(this.commit, "commit");
                this.commit = commit;
                return this;
            }

            @Override
            InternalTag build() {
                PersistentBase.checkSet(Builder.this.name, "name");
                PersistentBase.checkSet(this.commit, "commit");
                return new InternalTag(Builder.this.id, Builder.this.name, this.commit, this.dt);
            }

            @Override
            public Ref backToRef() {
                return Builder.this;
            }
        }
    }

    public static enum Type {
        BRANCH("b"),
        TAG("t"),
        HASH(null),
        UNKNOWN(null);

        private final Entity value;

        private Type(String identifier) {
            this.value = Entity.ofString(identifier);
        }

        public ExpressionFunction typeVerification() {
            return ExpressionFunction.equals(ExpressionPath.builder(InternalRef.TYPE).build(), this.toEntity());
        }

        public Entity toEntity() {
            if (this == HASH) {
                throw new IllegalStateException("You should not try to retrieve the identifier for a hash type since they are not saveable as searchable refs.");
            }
            return this.value;
        }

        public static Type getType(String identifier) {
            if (identifier.equals("b")) {
                return BRANCH;
            }
            if (identifier.equals("t")) {
                return TAG;
            }
            throw new IllegalArgumentException(String.format("Unknown identifier name [%s].", identifier));
        }
    }
}

