/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Objects;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.Ref;

class InternalTag
extends InternalRef {
    static final String COMMIT = "commit";
    private final String name;
    private final Id commit;

    InternalTag(Id id, String name, Id commit, Long dt) {
        super(id, dt);
        this.name = name;
        this.commit = commit;
    }

    @Override
    Id generateId() {
        return Id.build(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Id getCommit() {
        return this.commit;
    }

    @Override
    public InternalRef.Type getType() {
        return InternalRef.Type.TAG;
    }

    @Override
    public InternalTag getTag() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTag that = (InternalTag)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.commit, (Object)that.commit);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.commit});
    }

    @Override
    Ref applyToConsumer(Ref consumer) {
        return super.applyToConsumer(consumer).name(this.name).tag().commit(this.commit).backToRef();
    }
}

