/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.ImmutableKeyMutationList;
import org.projectnessie.versioned.impl.InternalMutation;
import org.projectnessie.versioned.store.Entity;

@Value.Immutable
abstract class KeyMutationList {
    KeyMutationList() {
    }

    abstract List<InternalMutation> getMutations();

    static KeyMutationList of(List<InternalMutation> mutations) {
        return ImmutableKeyMutationList.builder().mutations(mutations).build();
    }

    public Entity toEntity() {
        return Entity.ofList(this.getMutations().stream().map(InternalMutation::toEntity).collect(Collectors.toList()));
    }

    public static boolean equalsIgnoreOrder(KeyMutationList l1, KeyMutationList l2) {
        if (l1 != null && l2 == null) {
            return false;
        }
        if (l1 == null && l2 != null) {
            return false;
        }
        if (l1 == null) {
            return true;
        }
        return l1.equalsIgnoreOrder(l2);
    }

    public boolean equalsIgnoreOrder(KeyMutationList o) {
        if (o == null) {
            return false;
        }
        List<InternalMutation> mm = this.getMutations();
        List<InternalMutation> om = o.getMutations();
        if (mm.size() != om.size()) {
            return false;
        }
        HashSet<InternalMutation> s = new HashSet<InternalMutation>(mm);
        for (InternalMutation km : om) {
            if (s.contains(km)) continue;
            return false;
        }
        return true;
    }
}

