/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.ImmutableParentList;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;

@Value.Immutable
abstract class ParentList {
    static final int MAX_PARENT_LIST_SIZE = 50;
    public static final ParentList EMPTY = ImmutableParentList.builder().addParents(Id.EMPTY).build();

    ParentList() {
    }

    public abstract List<Id> getParents();

    public ParentList cloneWithAdditional(Id id) {
        return ImmutableParentList.builder().addAllParents((Iterable)Stream.concat(Stream.of(id), this.getParents().stream()).limit(50L).collect(ImmutableList.toImmutableList())).build();
    }

    public final Id getParent() {
        return this.getParents().get(0);
    }

    public Entity toEntity() {
        return Entity.ofList(this.getParents().stream().map(Id::toEntity));
    }

    public static ParentList of(Stream<Id> ancestors) {
        return ancestors.collect(ImmutableParentList::builder, ImmutableParentList.Builder::addParents, (a, b) -> {
            throw new UnsupportedOperationException();
        }).build();
    }
}

