/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.impl.EntityLoadOps;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalRefId;
import org.projectnessie.versioned.impl.InternalValue;
import org.projectnessie.versioned.impl.KeyMutationList;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.Pointer;
import org.projectnessie.versioned.impl.PositionDelta;
import org.projectnessie.versioned.impl.ValueHolder;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.SaveOp;

class PartialTree<V, E extends Enum<E>> {
    private final SerializerWithPayload<V, E> serializer;
    private final InternalRefId refId;
    private InternalRef.Type refType;
    private Id rootId;
    private Pointer<InternalL1> l1;
    private final Map<Integer, Pointer<InternalL2>> l2s = new HashMap<Integer, Pointer<InternalL2>>();
    private final Map<InternalKey.Position, Pointer<InternalL3>> l3s = new HashMap<InternalKey.Position, Pointer<InternalL3>>();
    private final Map<InternalKey, ValueHolder<V>> values = new HashMap<InternalKey, ValueHolder<V>>();
    private final Collection<InternalKey> keys;

    static <V, E extends Enum<E>> PartialTree<V, E> of(SerializerWithPayload<V, E> serializer, InternalRefId id, List<InternalKey> keys) {
        return new PartialTree<V, E>(serializer, id, keys);
    }

    static <V, E extends Enum<E>> PartialTree<V, E> of(SerializerWithPayload<V, E> serializer, InternalRef.Type refType, InternalL1 l1, Collection<InternalKey> keys) {
        PartialTree<V, E> tree = new PartialTree<V, E>(serializer, InternalRefId.ofHash(l1.getId()), keys);
        tree.l1 = new Pointer<InternalL1>(l1);
        tree.refType = refType;
        return tree;
    }

    private void checkMutable() {
        Preconditions.checkArgument((this.refType == InternalRef.Type.BRANCH ? 1 : 0) != 0, (String)"You can only mutate a partial tree that references a branch. This is type %s.", (Object)this.refType.name());
    }

    private PartialTree(SerializerWithPayload<V, E> serializer, InternalRefId refId, Collection<InternalKey> keys) {
        this.refId = refId;
        this.serializer = serializer;
        this.keys = keys;
    }

    public LoadStep getLoadChain(Function<InternalBranch, InternalL1> l1Converter, LoadType loadType) {
        if (this.refId.getType() == InternalRef.Type.HASH && this.l1 == null) {
            this.rootId = this.refId.getId();
            this.refType = InternalRef.Type.HASH;
            return this.getLoadStep1(loadType).get();
        }
        if (this.l1 != null) {
            return this.getLoadStep1(loadType).get();
        }
        EntityLoadOps loadOps = new EntityLoadOps();
        loadOps.load(EntityType.REF, InternalRef.class, this.refId.getId(), loadedRef -> {
            this.refType = loadedRef.getType();
            if (loadedRef.getType() == InternalRef.Type.BRANCH) {
                InternalL1 loaded = (InternalL1)l1Converter.apply(loadedRef.getBranch());
                this.l1 = new Pointer<InternalL1>(loaded);
                this.rootId = loaded.getId();
            } else if (loadedRef.getType() == InternalRef.Type.TAG) {
                this.rootId = loadedRef.getTag().getCommit();
            } else {
                throw new IllegalStateException("Unknown type of ref to be loaded from store.");
            }
        });
        return loadOps.build(() -> this.getLoadStep1(loadType));
    }

    public InternalL1 getCurrentL1() {
        return this.l1.get();
    }

    public Stream<SaveOp<?>> getMostSaveOps() {
        this.checkMutable();
        return Streams.concat((Stream[])new Stream[]{this.l2s.values().stream().filter(Pointer::isDirty).map(l2p -> EntityType.L2.createSaveOpForEntity((InternalL2)l2p.get())).distinct(), this.l3s.values().stream().filter(Pointer::isDirty).map(l3p -> EntityType.L3.createSaveOpForEntity((InternalL3)l3p.get())).distinct(), this.values.values().stream().map(v -> EntityType.VALUE.createSaveOpForEntity((InternalValue)v.getPersistentValue())).distinct()});
    }

    public CommitOp getCommitOp(Id metadataId, Collection<InternalKey> unchangedKeys, boolean includeTreeUpdates, boolean includeCommitUpdates) {
        ExpressionPath p;
        this.checkMutable();
        UpdateExpression treeUpdate = UpdateExpression.initial();
        HashSet<Integer> conditionPositions = new HashSet<Integer>();
        ArrayList<InternalBranch.UnsavedDelta> deltas = new ArrayList<InternalBranch.UnsavedDelta>();
        ConditionExpression treeCondition = ConditionExpression.of(ExpressionFunction.equals(ExpressionPath.builder("type").build(), InternalRef.Type.BRANCH.toEntity()));
        for (PositionDelta pm : this.l1.get().getChanges()) {
            boolean added = conditionPositions.add(pm.getPosition());
            assert (added);
            p = ExpressionPath.builder("tree").position(pm.getPosition()).build();
            if (includeTreeUpdates) {
                treeUpdate = treeUpdate.and(SetClause.equals(p, pm.getNewId().toEntity()));
                treeCondition = treeCondition.and(ExpressionFunction.equals(p, pm.getOldId().toEntity()));
            }
            deltas.add(pm.toUnsavedDelta());
        }
        for (InternalKey unchanged : unchangedKeys) {
            int position = unchanged.getL1Position();
            if (!includeTreeUpdates || !conditionPositions.add(position)) continue;
            p = ExpressionPath.builder("tree").position(position).build();
            treeCondition = treeCondition.and(ExpressionFunction.equals(p, this.getCurrentL1().getId(position).toEntity()));
        }
        InternalBranch.Commit commitIntention = null;
        if (includeCommitUpdates) {
            commitIntention = new InternalBranch.Commit(Id.generateRandom(), metadataId, deltas, KeyMutationList.of(this.l3s.values().stream().map(Pointer::get).flatMap(InternalL3::getMutations).collect(Collectors.toList())));
        }
        return new CommitOp(includeCommitUpdates ? commitIntention : null, includeTreeUpdates ? treeUpdate : null, includeTreeUpdates ? treeCondition : null);
    }

    private Optional<LoadStep> getLoadStep1(LoadType loadType) {
        Supplier<Optional<LoadStep>> loadFunc = () -> this.getLoadStep2(loadType == LoadType.SELECT_VALUES);
        if (this.l1 != null) {
            return loadFunc.get();
        }
        EntityLoadOps loadOps = new EntityLoadOps();
        loadOps.load(EntityType.L1, InternalL1.class, this.rootId, l -> {
            this.l1 = new Pointer<InternalL1>((InternalL1)l);
        });
        return Optional.of(loadOps.build(loadFunc));
    }

    private Optional<LoadStep> getLoadStep2(boolean includeValues) {
        EntityLoadOps loadOps = new EntityLoadOps();
        this.keys.forEach(id -> {
            Id l2Id = this.l1.get().getId(id.getL1Position());
            loadOps.load(EntityType.L2, InternalL2.class, l2Id, l -> this.l2s.putIfAbsent(id.getL1Position(), new Pointer<InternalL2>((InternalL2)l)));
        });
        return Optional.of(loadOps.build(() -> this.getLoadStep3(includeValues)));
    }

    private Optional<LoadStep> getLoadStep3(boolean includeValues) {
        EntityLoadOps loadOps = new EntityLoadOps();
        this.keys.forEach(keyId -> {
            InternalL2 l2 = this.l2s.get(keyId.getL1Position()).get();
            Id l3Id = l2.getId(keyId.getL2Position());
            loadOps.load(EntityType.L3, InternalL3.class, l3Id, l -> this.l3s.putIfAbsent(keyId.getPosition(), new Pointer<InternalL3>((InternalL3)l)));
        });
        return Optional.of(loadOps.build(() -> this.getLoadStep4(includeValues)));
    }

    private Optional<LoadStep> getLoadStep4(boolean includeValues) {
        if (!includeValues) {
            return Optional.empty();
        }
        EntityLoadOps loadOps = new EntityLoadOps();
        this.keys.forEach(key -> {
            InternalL3 l3 = this.l3s.get(key.getPosition()).get();
            Id id = l3.getId((InternalKey)key);
            if (!id.isEmpty()) {
                loadOps.load(EntityType.VALUE, InternalValue.class, l3.getId((InternalKey)key), wvb -> this.values.putIfAbsent((InternalKey)key, ValueHolder.of(this.serializer, wvb)));
            }
        });
        return loadOps.buildOptional();
    }

    public Optional<Id> getValueIdForKey(InternalKey key) {
        return this.l3s.get(key.getPosition()).get().getPossibleId(key);
    }

    public Optional<V> getValueForKey(InternalKey key) {
        ValueHolder<V> vh = this.values.get(key);
        if (vh == null) {
            return Optional.empty();
        }
        return Optional.of(vh.getValue());
    }

    public void setValueIdForKey(InternalKey key, Optional<Id> id) {
        Id valueId;
        this.checkMutable();
        Pointer<InternalL1> l1 = this.l1;
        Pointer<InternalL2> l2 = this.l2s.get(key.getL1Position());
        Pointer<InternalL3> l3 = this.l3s.get(key.getPosition());
        if (id.isPresent()) {
            valueId = id.get();
        } else {
            this.values.remove(key);
            valueId = Id.EMPTY;
        }
        Id newL3Id = l3.apply(l -> l.set(key, valueId, null));
        Id newL2Id = l2.apply(l -> l.set(key.getL2Position(), newL3Id));
        l1.apply(l -> l.set(key.getL1Position(), newL2Id));
    }

    public void setValueForKey(InternalKey key, Optional<V> value) {
        Byte payload;
        Id valueId;
        this.checkMutable();
        Pointer<InternalL1> l1 = this.l1;
        Pointer<InternalL2> l2 = this.l2s.get(key.getL1Position());
        Pointer<InternalL3> l3 = this.l3s.get(key.getPosition());
        if (value.isPresent()) {
            ValueHolder<V> holder = ValueHolder.of(this.serializer, value.get());
            this.values.put(key, holder);
            valueId = holder.getId();
            payload = this.serializer.getPayload(value.get());
        } else {
            this.values.remove(key);
            valueId = Id.EMPTY;
            payload = null;
        }
        Id newL3Id = l3.apply(l -> l.set(key, valueId, payload));
        Id newL2Id = l2.apply(l -> l.set(key.getL2Position(), newL3Id));
        l1.apply(l -> l.set(key.getL1Position(), newL2Id));
    }

    public PartialTree<V, E> cleanClone() {
        PartialTree<V, E> clone = new PartialTree<V, E>(this.serializer, this.refId, this.keys);
        this.l3s.entrySet().stream().map(x -> new AbstractMap.SimpleImmutableEntry<InternalKey.Position, Pointer<InternalL3>>((InternalKey.Position)x.getKey(), PartialTree.cloneInner(EntityType.L3, (Pointer)x.getValue()))).forEach(x -> clone.l3s.put((InternalKey.Position)x.getKey(), (Pointer)x.getValue()));
        this.l2s.entrySet().stream().map(x -> new AbstractMap.SimpleImmutableEntry<Integer, Pointer<InternalL2>>((Integer)x.getKey(), PartialTree.cloneInner(EntityType.L2, (Pointer)x.getValue()))).forEach(x -> clone.l2s.put((Integer)x.getKey(), (Pointer)x.getValue()));
        this.values.forEach(clone.values::put);
        clone.refType = this.refType;
        clone.rootId = this.rootId;
        clone.l1 = PartialTree.cloneInner(EntityType.L1, this.l1);
        return clone;
    }

    private static <T extends PersistentBase<?>> Pointer<T> cloneInner(EntityType<?, T, ?> type, Pointer<T> value) {
        if (value.isDirty()) {
            return new Pointer<T>(type.buildEntity(producer -> ((PersistentBase)value.get()).applyToConsumer(producer)));
        }
        return value;
    }

    public static class CommitOp {
        private final InternalBranch.Commit commitIntention;
        private final UpdateExpression treeUpdate;
        private final ConditionExpression treeCondition;

        public CommitOp(InternalBranch.Commit commitIntention, UpdateExpression treeUpdate, ConditionExpression condition) {
            this.commitIntention = commitIntention;
            this.treeUpdate = treeUpdate;
            this.treeCondition = condition;
        }

        public UpdateExpression getTreeUpdate() {
            return (UpdateExpression)Preconditions.checkNotNull((Object)this.treeUpdate);
        }

        public UpdateExpression getUpdateWithCommit() {
            return this.getTreeUpdate().and(CommitOp.getCommitSet(Collections.singletonList(this.commitIntention)));
        }

        public InternalBranch.Commit getCommitIntention() {
            return (InternalBranch.Commit)Preconditions.checkNotNull((Object)this.commitIntention);
        }

        public ConditionExpression getTreeCondition() {
            return (ConditionExpression)Preconditions.checkNotNull((Object)this.treeCondition);
        }

        static SetClause getCommitSet(List<InternalBranch.Commit> commits) {
            return SetClause.appendToList(ExpressionPath.builder("commits").build(), Entity.ofList(commits.stream().map(InternalBranch.Commit::toEntity)));
        }
    }

    public static enum LoadType {
        NO_VALUES,
        SELECT_VALUES;

    }
}

