/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import org.immutables.value.Value;
import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.ImmutableSetClause;
import org.projectnessie.versioned.impl.condition.UpdateClause;
import org.projectnessie.versioned.impl.condition.UpdateClauseVisitor;
import org.projectnessie.versioned.impl.condition.Value;
import org.projectnessie.versioned.store.Entity;

@Value.Immutable
public abstract class SetClause
implements UpdateClause {
    public abstract ExpressionPath getPath();

    public abstract Value getValue();

    @Override
    public <T> T accept(UpdateClauseVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static SetClause equals(ExpressionPath path, Entity value) {
        return ImmutableSetClause.builder().path(path).value(Value.of(value)).build();
    }

    public static SetClause appendToList(ExpressionPath path, Entity value) {
        return ImmutableSetClause.builder().path(path).value(ExpressionFunction.appendToList(path, value)).build();
    }

    @Override
    public SetClause alias(AliasCollector c) {
        return ImmutableSetClause.builder().path(this.getPath().alias(c)).value(this.getValue().alias(c)).build();
    }

    @Override
    public UpdateClause.Type getType() {
        return UpdateClause.Type.SET;
    }

    @Override
    public String toClauseString() {
        return String.format("%s = %s", this.getPath().asString(), this.getValue().asString());
    }
}

