/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.KeyDelta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyDelta", generator="Immutables")
@Immutable
public final class ImmutableKeyDelta
implements KeyDelta {
    private final Key key;
    private final Id id;
    @Nullable
    private final Byte payload;

    private ImmutableKeyDelta(Key key, Id id, @Nullable Byte payload) {
        this.key = key;
        this.id = id;
        this.payload = payload;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Id getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Byte getPayload() {
        return this.payload;
    }

    public final ImmutableKeyDelta withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyDelta(newValue, this.id, this.payload);
    }

    public final ImmutableKeyDelta withId(Id value) {
        if (this.id == value) {
            return this;
        }
        Id newValue = Objects.requireNonNull(value, "id");
        return new ImmutableKeyDelta(this.key, newValue, this.payload);
    }

    public final ImmutableKeyDelta withPayload(@Nullable Byte value) {
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableKeyDelta(this.key, this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyDelta && this.equalTo((ImmutableKeyDelta)another);
    }

    private boolean equalTo(ImmutableKeyDelta another) {
        return this.key.equals((Object)another.key) && this.id.equals(another.id) && Objects.equals(this.payload, another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.payload);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyDelta").omitNullValues().add("key", (Object)this.key).add("id", (Object)this.id).add("payload", (Object)this.payload).toString();
    }

    public static ImmutableKeyDelta copyOf(KeyDelta instance) {
        if (instance instanceof ImmutableKeyDelta) {
            return (ImmutableKeyDelta)instance;
        }
        return ImmutableKeyDelta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyDelta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Key key;
        @Nullable
        private Id id;
        @Nullable
        private Byte payload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyDelta instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.id(instance.getId());
            Byte payloadValue = instance.getPayload();
            if (payloadValue != null) {
                this.payload(payloadValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(Id id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(@Nullable Byte payload) {
            this.payload = payload;
            return this;
        }

        public ImmutableKeyDelta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyDelta(this.key, this.id, this.payload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build KeyDelta, some of required attributes are not set " + attributes;
        }
    }
}

