/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.noop.NoopSpanBuilder;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.impl.DT;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.IdMap;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalRefId;
import org.projectnessie.versioned.impl.KeyMutationList;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.RemoveClause;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.L1;
import org.projectnessie.versioned.tiered.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalBranch
extends InternalRef {
    static final String ID = "id";
    static final String TREE = "tree";
    static final String COMMITS = "commits";
    private static final List<Commit> SINGLE_EMPTY_COMMIT = ImmutableList.of((Object)new Commit(InternalL1.EMPTY_ID, Id.EMPTY, Id.EMPTY));
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalBranch.class);
    private static final String TAG_OPERATION = "nessie.operation";
    private static final String TAG_BRANCH = "nessie.branch";
    private final String name;
    private final IdMap tree;
    private final Id metadata;
    private final List<Commit> commits;

    public InternalBranch(String name) {
        this(InternalRefId.ofBranch(name).getId(), name, InternalL1.EMPTY.getMap(), Id.EMPTY, SINGLE_EMPTY_COMMIT, DT.now());
    }

    public InternalBranch(String name, InternalL1 target) {
        this(InternalRefId.ofBranch(name).getId(), name, target.getMap(), Id.EMPTY, (List<Commit>)ImmutableList.of((Object)new Commit(target.getId(), target.getMetadataId(), target.getParentId())), DT.now());
    }

    InternalBranch(Id id, String name, IdMap tree, Id metadata, List<Commit> commits, Long dt) {
        super(id, dt);
        this.metadata = metadata;
        this.name = name;
        this.tree = tree;
        this.commits = commits;
        assert (tree.size() == 43);
        this.ensureConsistentId();
    }

    Id getLastDefinedParent() {
        for (Commit c : Lists.reverse(this.commits)) {
            if (!c.isSaved()) continue;
            return c.id;
        }
        throw new IllegalStateException("Unable to determine last defined parent.");
    }

    public String getName() {
        return this.name;
    }

    public UpdateState getUpdateState(Store store) {
        InternalL1 lastSavedL1;
        ArrayList<Commit> unsavedCommits = new ArrayList<Commit>();
        Commit lastSavedCommit = null;
        boolean inUnsaved = false;
        assert (!this.commits.isEmpty());
        int unsavedStartOffset = 0;
        Commit lastUnsaved = null;
        for (Commit c : this.commits) {
            if (c.saved.booleanValue()) {
                lastSavedCommit = c;
                ++unsavedStartOffset;
                assert (!inUnsaved);
                continue;
            }
            assert (lastSavedCommit != null);
            inUnsaved = true;
            unsavedCommits.add(c);
            lastUnsaved = c;
        }
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int i = 0; i < this.commits.size() - 1; ++i) {
            deletes.add(new Delete(i, this.commits.get(i).id));
        }
        IdMap tree = this.tree;
        InternalL1 internalL1 = lastSavedL1 = lastSavedCommit.id.isEmpty() ? InternalL1.EMPTY : EntityType.L1.loadSingle(store, lastSavedCommit.id);
        if (unsavedCommits.isEmpty()) {
            return new UpdateState(Collections.emptyList(), deletes, lastSavedL1, 0, lastSavedL1.getId(), this);
        }
        for (Commit c : Lists.reverse(unsavedCommits)) {
            for (UnsavedDelta delta : c.deltas) {
                tree = delta.reverse(tree);
            }
        }
        InternalL1 lastL1 = lastSavedL1;
        int lastPos = unsavedStartOffset;
        Id lastId = null;
        ArrayList<SaveOp<L1>> toSave = new ArrayList<SaveOp<L1>>();
        HashMap<Id, InternalL1> unsavedL1s = new HashMap<Id, InternalL1>();
        for (Commit c : unsavedCommits) {
            for (UnsavedDelta delta : c.deltas) {
                tree = delta.apply(tree);
            }
            unsavedL1s.put(lastL1.getId(), lastL1);
            lastL1 = lastL1.getChildWithTree(c.commit, tree, c.keyMutationList).withCheckpointAsNecessary(store, unsavedL1s);
            toSave.add(EntityType.L1.createSaveOpForEntity(lastL1));
            lastId = c.id;
            if (lastUnsaved == c) continue;
            ++lastPos;
        }
        assert (tree.equals(this.tree));
        return new UpdateState(toSave, deletes, lastL1, lastPos, lastId, this);
    }

    @Override
    Id generateId() {
        return Id.build(this.name);
    }

    @Override
    public InternalRef.Type getType() {
        return InternalRef.Type.BRANCH;
    }

    @Override
    public InternalBranch getBranch() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalBranch that = (InternalBranch)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.tree, (Object)that.tree) && Objects.equal((Object)this.metadata, (Object)that.metadata) && Objects.equal(this.commits, that.commits);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.tree, this.metadata, this.commits});
    }

    @Override
    Ref applyToConsumer(Ref consumer) {
        return super.applyToConsumer(consumer).name(this.name).branch().metadata(this.metadata).children(this.tree.stream()).commits(cc -> {
            for (Commit c : this.commits) {
                cc.id(c.id).commit(c.commit);
                if (c.saved.booleanValue()) {
                    cc.saved().parent(c.parent).done();
                    continue;
                }
                Ref.UnsavedCommitDelta deltas = cc.unsaved();
                c.deltas.forEach(d -> deltas.delta(((UnsavedDelta)d).position, ((UnsavedDelta)d).oldId, ((UnsavedDelta)d).newId));
                Ref.UnsavedCommitMutations mutations = deltas.mutations();
                c.keyMutationList.getMutations().forEach(km -> mutations.keyMutation(km.toMutation()));
                mutations.done();
            }
        }).backToRef();
    }

    @VisibleForTesting
    List<Commit> getCommits() {
        return Collections.unmodifiableList(this.commits);
    }

    private static Tracer.SpanBuilder createSpan(boolean enableTracing, String name) {
        if (enableTracing) {
            Tracer tracer = GlobalTracer.get();
            return tracer.buildSpan(name).asChildOf(tracer.activeSpan());
        }
        return NoopSpanBuilder.INSTANCE;
    }

    static /* synthetic */ Tracer.SpanBuilder access$600(boolean x0, String x1) {
        return InternalBranch.createSpan(x0, x1);
    }

    public static class UnsavedDelta {
        private static final String POSITION = "position";
        private static final String NEW_ID = "new";
        private static final String OLD_ID = "old";
        private final int position;
        private final Id oldId;
        private final Id newId;

        public UnsavedDelta(int position, Id oldId, Id newId) {
            this.position = position;
            this.oldId = oldId;
            this.newId = newId;
        }

        public IdMap apply(IdMap tree) {
            return tree.withId(this.position, this.newId);
        }

        public IdMap reverse(IdMap tree) {
            return tree.withId(this.position, this.oldId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnsavedDelta that = (UnsavedDelta)o;
            return this.position == that.position && Objects.equal((Object)this.oldId, (Object)that.oldId) && Objects.equal((Object)this.newId, (Object)that.newId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.position, this.oldId, this.newId});
        }

        Map<String, Entity> itemToMap() {
            return ImmutableMap.builder().put((Object)POSITION, (Object)Entity.ofNumber(this.position)).put((Object)OLD_ID, (Object)this.oldId.toEntity()).put((Object)NEW_ID, (Object)this.newId.toEntity()).build();
        }
    }

    static class Delete {
        int position;
        Id id;

        public Delete(int position, Id id) {
            this.position = position;
            this.id = id;
        }
    }

    static final class UpdateState {
        private volatile boolean saved = false;
        private final List<SaveOp<?>> saves;
        private final List<Delete> deletes;
        private final InternalL1 finalL1;
        private final int finalL1position;
        private final Id finalL1RandomId;
        private final InternalBranch initialBranch;

        private UpdateState(List<SaveOp<?>> saves, List<Delete> deletes, InternalL1 finalL1, int finalL1position, Id finalL1RandomId, InternalBranch initialBranch) {
            this.saves = (List)Preconditions.checkNotNull(saves);
            this.deletes = (List)Preconditions.checkNotNull(deletes);
            this.finalL1 = (InternalL1)Preconditions.checkNotNull((Object)finalL1);
            this.finalL1position = finalL1position;
            this.finalL1RandomId = (Id)Preconditions.checkNotNull((Object)finalL1RandomId);
            this.initialBranch = (InternalBranch)Preconditions.checkNotNull((Object)initialBranch);
            if (finalL1position == 0 && !deletes.isEmpty()) {
                throw new IllegalStateException("We should never have deletes if the final position is zero.");
            }
        }

        @VisibleForTesting
        InternalL1 unsafeGetL1() {
            return this.finalL1;
        }

        private void save(Store store) {
            if (this.saved) {
                return;
            }
            if (this.saves.isEmpty()) {
                this.saved = true;
                return;
            }
            store.save(this.saves);
            this.saved = true;
        }

        void ensureAvailable(Store store, Executor executor, TieredVersionStoreConfig config) {
            this.save(store);
            if (this.saves.isEmpty()) {
                return;
            }
            CompletableFuture<InternalBranch> future = CompletableFuture.supplyAsync(() -> {
                try {
                    return UpdateState.collapseIntentionLog(this, store, this.initialBranch, config);
                }
                catch (ReferenceConflictException | ReferenceNotFoundException e) {
                    throw new CompletionException(e);
                }
            }, executor);
            if (!config.waitOnCollapse()) {
                return;
            }
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new IllegalStateException(e.getCause());
            }
        }

        /*
         * Exception decompiling
         */
        private static InternalBranch collapseIntentionLog(UpdateState updateState, Store store, InternalBranch branch, TieredVersionStoreConfig config) throws ReferenceNotFoundException, ReferenceConflictException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[FORLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static Scope scope(boolean enableTracing, Span span) {
            if (enableTracing) {
                Tracer tracer = GlobalTracer.get();
                return tracer.activateSpan(span);
            }
            return NoopScopeManager.NoopScope.INSTANCE;
        }

        private static Optional<InternalBranch> tryCollapseIntentionLog(Store store, InternalBranch branch, UpdateState updateState, int attempt) {
            updateState.save(store);
            ExpressionPath commits = ExpressionPath.builder(InternalBranch.COMMITS).build();
            ExpressionPath last = commits.toBuilder().position(updateState.finalL1position).build();
            UpdateExpression update = UpdateExpression.initial();
            ConditionExpression condition = ConditionExpression.initial();
            for (Delete d : updateState.deletes) {
                ExpressionPath path = commits.toBuilder().position(d.position).build();
                condition = condition.and(ExpressionFunction.equals(path.toBuilder().name(InternalBranch.ID).build(), d.id.toEntity()));
                update = update.and(RemoveClause.of(path));
            }
            condition = condition.and(ExpressionFunction.equals(last.toBuilder().name(InternalBranch.ID).build(), updateState.finalL1RandomId.toEntity()));
            update = update.and(RemoveClause.of(last.toBuilder().name("deltas").build())).and(RemoveClause.of(last.toBuilder().name("keys").build())).and(SetClause.equals(last.toBuilder().name("parent").build(), updateState.finalL1.getParentId().toEntity())).and(SetClause.equals(last.toBuilder().name(InternalBranch.ID).build(), updateState.finalL1.getId().toEntity()));
            InternalRef.Builder<?> producer = EntityType.REF.newEntityProducer();
            if (store.update(ValueType.REF, branch.getId(), update, Optional.of(condition), Optional.of(producer))) {
                LOGGER.debug("Completed collapse update on attempt {}, L1.id={}, L1.parentId={}, position={}.", new Object[]{attempt, updateState.finalL1.getId(), updateState.finalL1.getParentId(), updateState.finalL1position});
                return Optional.of(((InternalRef)producer.build()).getBranch());
            }
            LOGGER.debug("Failed to collapse update on attempt {}, L1.id={}, L1.parentId={}, position={}.", new Object[]{attempt, updateState.finalL1.getId(), updateState.finalL1.getParentId(), updateState.finalL1position});
            return Optional.empty();
        }

        public InternalL1 getL1() {
            Preconditions.checkArgument((boolean)this.saved, (Object)"You must call UpdateState.ensureAvailable() before attempting to retrieve the L1 state of this branch.");
            return this.finalL1;
        }
    }

    public static final class Commit {
        static final String ID = "id";
        static final String COMMIT = "commit";
        static final String DELTAS = "deltas";
        static final String PARENT = "parent";
        static final String KEY_MUTATIONS = "keys";
        private final Boolean saved;
        private final Id id;
        private final Id commit;
        private final Id parent;
        private final List<UnsavedDelta> deltas;
        private final KeyMutationList keyMutationList;

        public Commit(Id id, Id commit, Id parent) {
            this.id = id;
            this.parent = parent;
            this.commit = commit;
            this.saved = true;
            this.deltas = Collections.emptyList();
            this.keyMutationList = null;
        }

        public Commit(Id unsavedId, Id commit, List<UnsavedDelta> deltas, KeyMutationList keyMutationList) {
            this.saved = false;
            this.deltas = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(deltas)));
            this.commit = (Id)Preconditions.checkNotNull((Object)commit);
            this.parent = null;
            this.keyMutationList = (KeyMutationList)Preconditions.checkNotNull((Object)keyMutationList);
            this.id = (Id)Preconditions.checkNotNull((Object)unsavedId);
        }

        Id getId() {
            return this.id;
        }

        public boolean isSaved() {
            return this.saved;
        }

        public Entity toEntity() {
            return Entity.ofMap(this.itemToMap(this));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Commit commit1 = (Commit)o;
            return Objects.equal((Object)this.saved, (Object)commit1.saved) && Objects.equal((Object)this.id, (Object)commit1.id) && Objects.equal((Object)this.commit, (Object)commit1.commit) && Objects.equal((Object)this.parent, (Object)commit1.parent) && Objects.equal(this.deltas, commit1.deltas) && KeyMutationList.equalsIgnoreOrder(this.keyMutationList, commit1.keyMutationList);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.saved, this.id, this.commit, this.parent, this.deltas, this.keyMutationList});
        }

        Map<String, Entity> itemToMap(Commit item) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"id", (Object)item.getId().toEntity()).put((Object)COMMIT, (Object)item.commit.toEntity());
            if (item.saved.booleanValue()) {
                builder.put((Object)PARENT, (Object)item.parent.toEntity());
            } else {
                Entity deltas = Entity.ofList(item.deltas.stream().map(UnsavedDelta::itemToMap).map(Entity::ofMap).collect(Collectors.toList()));
                builder.put((Object)DELTAS, (Object)deltas);
                builder.put((Object)KEY_MUTATIONS, (Object)item.keyMutationList.toEntity());
            }
            return builder.build();
        }
    }
}

