/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.WithPayload;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.Fragment;

class InternalFragment
extends PersistentBase<Fragment> {
    private final List<InternalKeyWithPayload> keys;

    InternalFragment(List<InternalKeyWithPayload> keys) {
        this.keys = ImmutableList.copyOf(keys);
    }

    InternalFragment(Id id, List<InternalKeyWithPayload> keys, Long dt) {
        super(id, dt);
        this.keys = ImmutableList.copyOf(keys);
    }

    @Override
    Id generateId() {
        return Id.build(h -> this.keys.forEach(k -> InternalKey.addToHasher(k.getKey(), h)));
    }

    List<InternalKeyWithPayload> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalFragment fragment = (InternalFragment)o;
        return Objects.equal(this.keys, fragment.keys);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keys});
    }

    @Override
    Fragment applyToConsumer(Fragment consumer) {
        return super.applyToConsumer(consumer).keys(this.keys.stream().map(InternalKeyWithPayload::toKey));
    }

    @Override
    public EntityType<Fragment, InternalFragment, Builder> getEntityType() {
        return EntityType.KEY_FRAGMENT;
    }

    static class Builder
    extends PersistentBase.EntityBuilder<InternalFragment, Fragment>
    implements Fragment {
        private List<InternalKeyWithPayload> keys;

        Builder() {
        }

        @Override
        public Builder keys(Stream<WithPayload<Key>> keys) {
            PersistentBase.checkCalled(this.keys, "keys");
            this.keys = keys.map(k -> InternalKeyWithPayload.of(k.getPayload(), (Key)k.getValue())).collect(Collectors.toList());
            return this;
        }

        @Override
        InternalFragment build() {
            PersistentBase.checkSet(this.keys, "keys");
            return new InternalFragment(this.id, this.keys, this.dt);
        }
    }
}

