/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.Id;

class InternalRefId
implements HasId {
    private final String name;
    private final Id id;
    private final InternalRef.Type type;

    private InternalRefId(String name, InternalRef.Type type) {
        this.name = name;
        this.id = Id.build(name);
        this.type = type;
    }

    private InternalRefId(Id id, InternalRef.Type type) {
        this.name = null;
        this.type = type;
        this.id = id;
    }

    public static InternalRefId of(Ref ref) throws ReferenceNotFoundException {
        if (ref instanceof BranchName) {
            return InternalRefId.ofBranch(((BranchName)ref).getName());
        }
        if (ref instanceof TagName) {
            return InternalRefId.ofTag(((TagName)ref).getName());
        }
        if (ref instanceof Hash) {
            return InternalRefId.ofHash((Hash)ref);
        }
        throw new IllegalStateException();
    }

    public static InternalRefId ofUnknownName(String name) {
        return new InternalRefId(name, InternalRef.Type.UNKNOWN);
    }

    public static InternalRefId ofTag(String name) {
        return new InternalRefId(name, InternalRef.Type.TAG);
    }

    public static InternalRefId ofBranch(String name) {
        return new InternalRefId(name, InternalRef.Type.BRANCH);
    }

    public static InternalRefId ofHash(Hash hash) throws ReferenceNotFoundException {
        return new InternalRefId(Id.of(hash), InternalRef.Type.HASH);
    }

    public static InternalRefId ofHash(Id id) {
        return new InternalRefId(id, InternalRef.Type.HASH);
    }

    @Override
    public Id getId() {
        return this.id;
    }

    public InternalRef.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

