/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.impl.InternalValue;
import org.projectnessie.versioned.impl.WrappedValueBean;
import org.projectnessie.versioned.store.Id;

class ValueHolder<V> {
    private final Serializer<V> serializer;
    private V value;
    private WrappedValueBean<?> bean;

    public ValueHolder(Serializer<V> serializer, V value, InternalValue bean) {
        this.serializer = serializer;
        this.value = value;
        this.bean = bean;
    }

    public V getValue() {
        if (this.value == null) {
            this.value = this.serializer.fromBytes(this.bean.getBytes());
        }
        return this.value;
    }

    public WrappedValueBean<?> getPersistentValue() {
        if (this.bean == null) {
            this.bean = InternalValue.of(this.serializer.toBytes(this.value));
        }
        return this.bean;
    }

    public Id getId() {
        return this.getPersistentValue().getId();
    }

    public static <V> ValueHolder<V> of(Serializer<V> serializer, V value) {
        return new ValueHolder<V>(serializer, value, null);
    }

    public static <V> ValueHolder<V> of(Serializer<V> serializer, InternalValue bean) {
        return new ValueHolder<Object>(serializer, null, bean);
    }
}

