/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.Value;
import org.projectnessie.versioned.impl.condition.ValueVisitor;
import org.projectnessie.versioned.store.Entity;

public class ExpressionFunction
implements Value {
    private final FunctionName name;
    private final List<Value> arguments;

    ExpressionFunction(FunctionName name, ImmutableList<Value> arguments) {
        this.name = name;
        this.arguments = ImmutableList.copyOf(arguments);
        Preconditions.checkArgument((this.arguments.size() == name.argCount ? 1 : 0) != 0, (Object)"Unexpected argument count.");
    }

    public static ExpressionFunction size(ExpressionPath path) {
        return new ExpressionFunction(FunctionName.SIZE, (ImmutableList<Value>)ImmutableList.of((Object)path));
    }

    public static ExpressionFunction appendToList(ExpressionPath initialList, Entity valueToAppend) {
        return new ExpressionFunction(FunctionName.LIST_APPEND, (ImmutableList<Value>)ImmutableList.of((Object)initialList, (Object)Value.of(valueToAppend)));
    }

    public static ExpressionFunction attributeNotExists(ExpressionPath path) {
        return new ExpressionFunction(FunctionName.ATTRIBUTE_NOT_EXISTS, (ImmutableList<Value>)ImmutableList.of((Object)path));
    }

    public static ExpressionFunction equals(ExpressionPath path, Entity value) {
        return new ExpressionFunction(FunctionName.EQUALS, (ImmutableList<Value>)ImmutableList.of((Object)path, (Object)Value.of(value)));
    }

    public static ExpressionFunction equals(ExpressionFunction func, Entity value) {
        return new ExpressionFunction(FunctionName.EQUALS, (ImmutableList<Value>)ImmutableList.of((Object)func, (Object)Value.of(value)));
    }

    @Override
    public ExpressionFunction alias(AliasCollector aliasCollector) {
        return new ExpressionFunction(this.name, (ImmutableList<Value>)((ImmutableList)this.arguments.stream().map(v -> v.alias(aliasCollector)).collect(ImmutableList.toImmutableList())));
    }

    @Override
    public String asString() {
        if (this.name.binaryExpression) {
            return String.format("%s %s %s", this.arguments.get(0).asString(), this.name.protocolName, this.arguments.get(1).asString());
        }
        return String.format("%s(%s)", this.name.protocolName, this.arguments.stream().map(Value::asString).collect(Collectors.joining(", ")));
    }

    @Override
    public Value.Type getType() {
        return Value.Type.FUNCTION;
    }

    @Override
    public ExpressionFunction getFunction() {
        return this;
    }

    public FunctionName getName() {
        return this.name;
    }

    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T accept(ValueVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum FunctionName {
        LIST_APPEND("list_append", 2),
        EQUALS("="),
        ATTRIBUTE_NOT_EXISTS("attribute_not_exists", 1),
        SIZE("size", 1);

        String protocolName;
        int argCount;
        boolean binaryExpression;

        private FunctionName(String text, int argCount) {
            this(text, argCount, false);
        }

        private FunctionName(String text, int argCount, boolean binaryExpression) {
            this.protocolName = text;
            this.argCount = argCount;
            this.binaryExpression = binaryExpression;
        }

        private FunctionName(String text) {
            this(text, 2, true);
        }

        public int getArgCount() {
            return this.argCount;
        }
    }
}

