/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectnessie.versioned.tiered.BaseValue;
import org.projectnessie.versioned.tiered.CommitMetadata;
import org.projectnessie.versioned.tiered.Fragment;
import org.projectnessie.versioned.tiered.L1;
import org.projectnessie.versioned.tiered.L2;
import org.projectnessie.versioned.tiered.L3;
import org.projectnessie.versioned.tiered.Ref;
import org.projectnessie.versioned.tiered.Value;

public final class ValueType<C extends BaseValue<C>> {
    public static final ValueType<Ref> REF = new ValueType<Ref>(Ref.class, "r", "refs");
    public static final ValueType<L1> L1 = new ValueType<L1>(L1.class, "l1", "l1");
    public static final ValueType<L2> L2 = new ValueType<L2>(L2.class, "l2", "l2");
    public static final ValueType<L3> L3 = new ValueType<L3>(L3.class, "l3", "l3");
    public static final ValueType<Value> VALUE = new ValueType<Value>(Value.class, "v", "values");
    public static final ValueType<Fragment> KEY_FRAGMENT = new ValueType<Fragment>(Fragment.class, "k", "key_lists");
    public static final ValueType<CommitMetadata> COMMIT_METADATA = new ValueType<CommitMetadata>(CommitMetadata.class, "m", "commit_metadata");
    private static final ValueType<?>[] ALL = new ValueType[]{REF, L1, L2, L3, VALUE, KEY_FRAGMENT, COMMIT_METADATA};
    public static final String SCHEMA_TYPE = "t";
    private static final Map<String, ValueType<?>> BY_VALUE_NAME = new HashMap();
    private final String valueName;
    private final String defaultTableSuffix;
    private final Class<C> clazz;

    private ValueType(Class<C> clazz, String valueName, String defaultTableSuffix) {
        this.valueName = valueName;
        this.defaultTableSuffix = defaultTableSuffix;
        this.clazz = clazz;
    }

    public Class<C> getValueClass() {
        return this.clazz;
    }

    public static List<ValueType<?>> values() {
        return Arrays.asList(ALL);
    }

    public static ValueType<?> byValueName(String t) {
        ValueType<?> type = BY_VALUE_NAME.get(t);
        if (type == null) {
            throw new IllegalArgumentException("No ValueType for table '" + t + "'");
        }
        return type;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getTableName(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.defaultTableSuffix;
        }
        return prefix + this.defaultTableSuffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueType valueType = (ValueType)o;
        return this.valueName.equals(valueType.valueName);
    }

    public int hashCode() {
        return this.valueName.hashCode();
    }

    public String name() {
        return this.defaultTableSuffix;
    }

    public String toString() {
        return this.defaultTableSuffix;
    }

    static {
        for (ValueType<?> type : ALL) {
            BY_VALUE_NAME.put(type.valueName, type);
        }
    }
}

